/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.category;

import de.javagl.category.CategoriesBuilder;
import de.javagl.category.Category;
import de.javagl.category.DefaultCategory;
import de.javagl.category.MutableCategory;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Categories {
    public static <T> CategoriesBuilder<T> createBuilder(String name) {
        return new CategoriesBuilder(name);
    }

    public static <T> MutableCategory<T> create(String name) {
        return new DefaultCategory(name);
    }

    public static <T> Set<T> getAllElements(Category<T> category) {
        LinkedHashSet result = new LinkedHashSet();
        Categories.getAllElements(category, result);
        return result;
    }

    private static <T> void getAllElements(Category<T> category, Set<T> result) {
        result.addAll(category.getElements());
        for (Category<T> child : category.getChildren()) {
            Categories.getAllElements(child, result);
        }
    }

    public static <T> void mergeRecursively(MutableCategory<T> target, Category<? extends T> source) {
        target.addElements(source.getElements());
        for (Category<T> sourceChild : source.getChildren()) {
            String name = sourceChild.getName();
            MutableCategory<T> targetChild = target.getChild(name);
            if (targetChild == null) {
                targetChild = target.addChild(name);
            }
            Categories.mergeRecursively(targetChild, sourceChild);
        }
    }

    public static void removeEmptyCategories(MutableCategory<?> category) {
        List<MutableCategory<?>> children = category.getChildren();
        for (MutableCategory<?> child : children) {
            Categories.removeEmptyCategories(child);
        }
        for (MutableCategory<?> child : children) {
            if (!child.getChildren().isEmpty() || !child.getElements().isEmpty()) continue;
            category.removeChild(child.getName());
        }
    }

    public static String toFormattedString(Category<?> category) {
        return Categories.toFormattedString(category, "");
    }

    private static String toFormattedString(Category<?> category, String indent) {
        int numChildren;
        if (category == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        String i = indent;
        if (indent.length() >= 2) {
            i = indent.substring(0, indent.length() - 2) + "+-";
        }
        sb.append(i + category.getName()).append("\n");
        if (!category.getElements().isEmpty()) {
            for (Object element : category.getElements()) {
                sb.append(indent + "|-" + element).append("\n");
            }
        }
        if ((numChildren = category.getChildren().size()) > 0) {
            int counter = 0;
            for (Category<?> child : category.getChildren()) {
                if (counter == numChildren - 1) {
                    sb.append(Categories.toFormattedString(child, indent + "  "));
                } else {
                    sb.append(Categories.toFormattedString(child, indent + "| "));
                }
                ++counter;
            }
        }
        return sb.toString();
    }

    private Categories() {
    }
}

