/*
 * Decompiled with CFR 0.152.
 */
package com.javacook.easyexcelaccess;

import com.javacook.coordinate.CoordinateInterface;
import com.javacook.coordinate.sequencer.ArrayConsumer;
import com.javacook.coordinate.sequencer.ArrayConsumerAndCounter;
import com.javacook.coordinate.sequencer.ArrayPredicate;
import com.javacook.coordinate.sequencer.ArrayPredicateAndCounter;
import com.javacook.coordinate.sequencer.Consumer;
import com.javacook.coordinate.sequencer.ConsumerAndCounter;
import com.javacook.coordinate.sequencer.CoordinateSequencer;
import com.javacook.coordinate.sequencer.PairConsumer;
import com.javacook.coordinate.sequencer.PairConsumerAndCounter;
import com.javacook.coordinate.sequencer.PairPredicate;
import com.javacook.coordinate.sequencer.PairPredicateAndCounter;
import com.javacook.coordinate.sequencer.Predicate;
import com.javacook.coordinate.sequencer.PredicateAndCounter;
import com.javacook.easyexcelaccess.ExcelCoordinate;
import com.javacook.easyexcelaccess.ExcelUtil;

public class ExcelCoordinateSequencer {
    protected final CoordinateSequencer<ExcelCoordinate> cs = new CoordinateSequencer((x, y) -> new ExcelCoordinate(x + 1, y + 1));

    private ExcelCoordinateSequencer fromX(int x) {
        this.cs.fromX(x);
        return this;
    }

    private ExcelCoordinateSequencer fromY(int y) {
        this.cs.fromY(y);
        return this;
    }

    public ExcelCoordinateSequencer from(int col, int row) {
        return this.fromCol(col).fromRow(row);
    }

    public ExcelCoordinateSequencer from(ExcelCoordinate coord) {
        return this.from(coord.col(), coord.row());
    }

    public ExcelCoordinateSequencer from(CoordinateInterface coord) {
        this.cs.from(coord);
        return this;
    }

    private ExcelCoordinateSequencer toX(int xTo) {
        this.cs.toX(xTo);
        return this;
    }

    private ExcelCoordinateSequencer toY(int yTo) {
        this.cs.toY(yTo);
        return this;
    }

    public ExcelCoordinateSequencer to(ExcelCoordinate coord) {
        return this.to(coord.col(), coord.row());
    }

    public ExcelCoordinateSequencer to(CoordinateInterface c) {
        this.cs.to(c);
        return this;
    }

    public ExcelCoordinateSequencer to(int col, int row) {
        return this.toCol(col).toRow(row);
    }

    private ExcelCoordinateSequencer forX(int x) {
        this.cs.forX(x);
        return this;
    }

    private ExcelCoordinateSequencer forY(int y) {
        this.cs.forY(y);
        return this;
    }

    public ExcelCoordinateSequencer forCoord(CoordinateInterface c) {
        return this.forX(c.x()).forY(c.y());
    }

    private ExcelCoordinateSequencer lenX(int len) {
        this.cs.lenX(len);
        return this;
    }

    public ExcelCoordinateSequencer lenY(int len) {
        this.cs.lenY(len);
        return this;
    }

    public ExcelCoordinateSequencer width(int width) {
        return this.lenX(width);
    }

    public ExcelCoordinateSequencer height(int height) {
        return this.lenY(height);
    }

    private ExcelCoordinateSequencer stepX(int step) {
        this.cs.stepX(step);
        return this;
    }

    private ExcelCoordinateSequencer stepY(int step) {
        this.cs.stepY(step);
        return this;
    }

    public ExcelCoordinateSequencer enter() {
        this.cs.enter();
        return this;
    }

    public ExcelCoordinateSequencer sequence() {
        this.cs.sequence();
        return this;
    }

    public ExcelCoordinateSequencer forEach(Consumer<ExcelCoordinate> action) {
        this.cs.forEach(action);
        return this;
    }

    public ExcelCoordinateSequencer forEach(ConsumerAndCounter<ExcelCoordinate> action) {
        this.cs.forEach(action);
        return this;
    }

    public ExcelCoordinateSequencer forEachPair(PairConsumer<ExcelCoordinate> action) {
        this.cs.forEachPair(action);
        return this;
    }

    public ExcelCoordinateSequencer forEachPair(PairConsumerAndCounter<ExcelCoordinate> action) {
        this.cs.forEachPair(action);
        return this;
    }

    public ExcelCoordinateSequencer forEachArray(ArrayConsumer<ExcelCoordinate> action) {
        this.cs.forEachArray(action);
        return this;
    }

    public ExcelCoordinateSequencer forEachArray(ArrayConsumerAndCounter<ExcelCoordinate> action) {
        this.cs.forEachArray(action);
        return this;
    }

    public ExcelCoordinateSequencer stopWhen(Predicate<ExcelCoordinate> action) {
        this.cs.stopWhen(action);
        return this;
    }

    public ExcelCoordinateSequencer stopWhen(PredicateAndCounter<ExcelCoordinate> action) {
        this.cs.stopWhen(action);
        return this;
    }

    public ExcelCoordinateSequencer stopWhenPair(PairPredicate<ExcelCoordinate> action) {
        this.cs.stopWhenPair(action);
        return this;
    }

    public ExcelCoordinateSequencer stopWhenPair(PairPredicateAndCounter<ExcelCoordinate> action) {
        this.cs.stopWhenPair(action);
        return this;
    }

    public ExcelCoordinateSequencer stopWhenArray(ArrayPredicate<ExcelCoordinate> action) {
        this.cs.stopWhenArray(action);
        return this;
    }

    public ExcelCoordinateSequencer stopWhenArray(ArrayPredicateAndCounter<ExcelCoordinate> action) {
        this.cs.stopWhenArray(action);
        return this;
    }

    public ExcelCoordinateSequencer fromRow(int row) {
        return this.fromY(row - 1);
    }

    public ExcelCoordinateSequencer toRow(int row) {
        return this.toY(row);
    }

    public ExcelCoordinateSequencer toRowMax() {
        return this.toRow(65536);
    }

    public ExcelCoordinateSequencer forRow(int row) {
        return this.forY(row - 1);
    }

    public ExcelCoordinateSequencer fromCol(int col) {
        return this.fromX(col - 1);
    }

    public ExcelCoordinateSequencer fromCol(char col) {
        return this.fromCol(Character.toString(col));
    }

    public ExcelCoordinateSequencer fromCol(String col) {
        return this.fromCol(ExcelUtil.calculateColNo(col));
    }

    public ExcelCoordinateSequencer toCol(int col) {
        return this.toX(col);
    }

    public ExcelCoordinateSequencer toCol(char col) {
        return this.toCol(Character.toString(col));
    }

    public ExcelCoordinateSequencer toCol(String col) {
        return this.toCol(ExcelUtil.calculateColNo(col));
    }

    public ExcelCoordinateSequencer toColMax() {
        return this.toCol(65536);
    }

    public ExcelCoordinateSequencer forCol(int col) {
        return this.forX(col - 1);
    }

    public ExcelCoordinateSequencer forCol(char col) {
        return this.forCol(Character.toString(col));
    }

    public ExcelCoordinateSequencer forCol(String col) {
        return this.forCol(ExcelUtil.calculateColNo(col));
    }

    public ExcelCoordinateSequencer horStep(int stepX) {
        return this.stepX(stepX);
    }

    public ExcelCoordinateSequencer vertStep(int stepY) {
        return this.stepY(stepY);
    }
}

