/*
 * Decompiled with CFR 0.152.
 */
package com.javacook.easyexcelaccess;

import com.javacook.coordinate.CoordinateInterface;
import com.javacook.easyexcelaccess.ExcelAccessor;
import com.javacook.easyexcelaccess.ExcelCoordinate;
import java.io.File;
import java.io.IOException;

public class ExcelCoordinateAccessor
extends ExcelAccessor {
    public final int defaultSheet;

    public ExcelCoordinateAccessor(String resourceName) throws IOException {
        this(resourceName, 0);
    }

    public ExcelCoordinateAccessor(File file) throws IOException {
        this(file, 0);
    }

    public ExcelCoordinateAccessor(String resourceName, int defaultSheet) throws IOException {
        super(resourceName);
        this.defaultSheet = defaultSheet;
    }

    public ExcelCoordinateAccessor(File file, int defaultSheet) throws IOException {
        super(file);
        this.defaultSheet = defaultSheet;
    }

    public boolean isEmpty(int sheetNo, CoordinateInterface coordinate) {
        return this.isEmpty(sheetNo, coordinate.x(), coordinate.y());
    }

    public boolean isOutside(int sheetNo, CoordinateInterface coordinate) {
        return this.isOutside(sheetNo, coordinate.x(), coordinate.y());
    }

    public Object read(int sheetNo, CoordinateInterface coord) {
        return this.readCell(sheetNo, coord.x(), coord.y());
    }

    public String readString(int sheetNo, CoordinateInterface coord) {
        return this.readCell(sheetNo, coord.x(), coord.y(), String.class);
    }

    public Integer readInteger(int sheetNo, CoordinateInterface coord) {
        return this.readCell(sheetNo, coord.x(), coord.y(), Integer.class);
    }

    public Long readLong(int sheetNo, CoordinateInterface coord) {
        return this.readCell(sheetNo, coord.x(), coord.y(), Long.class);
    }

    public Boolean readBoolean(int sheetNo, CoordinateInterface coord) {
        return this.readCell(sheetNo, coord.x(), coord.y(), Boolean.class);
    }

    public ExcelCoordinate find(int sheetNo, String word) {
        return this.find(sheetNo, word, false);
    }

    public ExcelCoordinate findInColumn(int sheetNo, int col, String word, boolean nullInsteadOfException) {
        for (int row = 1; row <= this.noRows(sheetNo); ++row) {
            if (!this.contains(word, sheetNo, col, row)) continue;
            return new ExcelCoordinate(col, row);
        }
        if (nullInsteadOfException) {
            return null;
        }
        throw new RuntimeException("Could not find '" + word + "' in sheet " + sheetNo + " and column " + col);
    }

    public ExcelCoordinate find(int sheetNo, String word, boolean nullInsteadOfException) {
        for (int col = 1; col <= this.noCols(sheetNo); ++col) {
            for (int row = 1; row <= this.noRows(sheetNo); ++row) {
                if (!this.contains(word, sheetNo, col, row)) continue;
                return new ExcelCoordinate(col, row);
            }
        }
        if (nullInsteadOfException) {
            return null;
        }
        throw new RuntimeException("Could not find '" + word + "' in sheet " + sheetNo);
    }

    protected boolean contains(String word, int sheetNo, int col, int row) {
        String content = this.readCell(sheetNo, col - 1, row - 1, String.class);
        return content == null && word == null || content != null && content.contains(word);
    }

    public boolean isEmpty(CoordinateInterface coord) {
        return this.isEmpty(this.defaultSheet, coord);
    }

    public boolean isOutside(CoordinateInterface coord) {
        return this.isOutside(this.defaultSheet, coord);
    }

    public Object read(CoordinateInterface coord) {
        return this.read(this.defaultSheet, coord);
    }

    public String readString(CoordinateInterface coord) {
        return this.readString(this.defaultSheet, coord);
    }

    public Integer readInteger(CoordinateInterface coord) {
        return this.readInteger(this.defaultSheet, coord);
    }

    public Long readLong(CoordinateInterface coord) {
        return this.readLong(this.defaultSheet, coord);
    }

    public Boolean readBoolean(CoordinateInterface coord) {
        return this.readBoolean(this.defaultSheet, coord);
    }

    public ExcelCoordinate find(String word) {
        return this.find(this.defaultSheet, word);
    }

    public ExcelCoordinate find(String word, boolean nullInsteadOfException) {
        return this.find(this.defaultSheet, word, nullInsteadOfException);
    }
}

