/*
 * Decompiled with CFR 0.152.
 */
package com.javacook.easyexcelaccess;

import com.javacook.coordinate.Coordinate;
import com.javacook.coordinate.CoordinateInterface;
import com.javacook.easyexcelaccess.ExcelUtil;

public class ExcelCoordinate
implements CoordinateInterface {
    public static final int COL_MAX = 65536;
    public static final int ROW_MAX = 65536;
    protected CoordinateInterface c;

    public ExcelCoordinate(int col, int row) {
        this((CoordinateInterface)new Coordinate(col - 1, row - 1));
    }

    public ExcelCoordinate(String col, int row) {
        this(ExcelUtil.calculateColNo(col), row);
    }

    public ExcelCoordinate(CoordinateInterface coord) {
        this.c = coord;
    }

    public int col() {
        return this.x() + 1;
    }

    public int row() {
        return this.y() + 1;
    }

    public ExcelCoordinate setCol(int newCol) {
        return new ExcelCoordinate(newCol, this.row());
    }

    public ExcelCoordinate setCol(String newCol) {
        return new ExcelCoordinate(ExcelUtil.calculateColNo(newCol), this.row());
    }

    public ExcelCoordinate setRow(int newRow) {
        return new ExcelCoordinate(this.col(), newRow);
    }

    public ExcelCoordinate setRow(String newRow) {
        return new ExcelCoordinate(this.col(), ExcelUtil.calculateColNo(newRow));
    }

    public ExcelCoordinate addRow(int diff) {
        return new ExcelCoordinate(this.col(), this.row() + diff);
    }

    public ExcelCoordinate add(int colDiff, int rowDiff) {
        return new ExcelCoordinate(this.col() + colDiff, this.row() + rowDiff);
    }

    public ExcelCoordinate subRow(int diff) {
        return new ExcelCoordinate(this.x(), this.y() - diff);
    }

    public ExcelCoordinate addCol(int diff) {
        return new ExcelCoordinate(this.col() + diff, this.row());
    }

    public ExcelCoordinate subCol(int diff) {
        return new ExcelCoordinate(this.col() - diff, this.row());
    }

    public ExcelCoordinate incRow() {
        return this.addRow(1);
    }

    public ExcelCoordinate incCol() {
        return this.addCol(1);
    }

    public ExcelCoordinate decRow() {
        return this.subRow(1);
    }

    public ExcelCoordinate decCol() {
        return this.subCol(1);
    }

    public boolean isLeftFrom(CoordinateInterface coord) {
        return this.x() < coord.x();
    }

    public boolean isRightFrom(CoordinateInterface coord) {
        return this.x() > coord.x();
    }

    public boolean isOver(CoordinateInterface coord) {
        return this.y() < coord.y();
    }

    public boolean isUnder(CoordinateInterface coord) {
        return this.y() > coord.y();
    }

    public boolean hasSameRow(CoordinateInterface coord) {
        return this.y() == coord.y();
    }

    public boolean hasSameCol(CoordinateInterface coord) {
        return this.x() == coord.x();
    }

    public String toString() {
        int col = this.col();
        String letters = ExcelUtil.calculateColLetters(col);
        return "[col=" + letters + " ,row=" + this.row() + "]";
    }

    public int x() {
        return this.c.x();
    }

    public int y() {
        return this.c.y();
    }
}

