/*
 * Decompiled with CFR 0.152.
 */
package com.javacook.easyexcelaccess;

import com.javacook.coordinate.CoordinateInterface;
import com.javacook.easyexcelaccess.ExcelEasyAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

public class ExcelAccessor
implements ExcelEasyAccess {
    public static final double EPSILON = 1.0E-10;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    final HSSFWorkbook workbook;

    public ExcelAccessor(String resourceName) throws IOException {
        try (InputStream is = ClassLoader.getSystemResourceAsStream(resourceName);){
            if (is == null) {
                throw new IllegalArgumentException("Resource '" + resourceName + " does not exist.");
            }
            this.workbook = new HSSFWorkbook(is);
        }
    }

    public ExcelAccessor(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            this.workbook = new HSSFWorkbook((InputStream)fis);
        }
    }

    public boolean isEmpty(int sheetNo, int x, int y) {
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNo);
        if (sheet == null) {
            return true;
        }
        HSSFRow row = sheet.getRow(y);
        if (row == null) {
            return true;
        }
        HSSFCell cell = row.getCell(x);
        if (cell == null) {
            return true;
        }
        return cell.getCellType() == CellType.BLANK;
    }

    public boolean isRowEmpty(int sheetNo, int row) {
        for (int col = 0; col < this.noCols(sheetNo); ++col) {
            if (this.isEmpty(sheetNo, col, row)) continue;
            return false;
        }
        return true;
    }

    public boolean isOutside(int sheetNo, int x, int y) {
        return x > this.noCols(sheetNo) || y > this.noRows(sheetNo);
    }

    @Override
    public Object readCell(int sheetNo, int x, int y) {
        if (this.isEmpty(sheetNo, x, y)) {
            return null;
        }
        try {
            HSSFCell cell = this.workbook.getSheetAt(sheetNo).getRow(y).getCell(x);
            return this.readCell(cell, cell.getCellType());
        }
        catch (Exception e) {
            throw new RuntimeException("Access to cell (sheet=" + sheetNo + ", x=" + x + ", y=" + y + ") failed", e);
        }
    }

    Object readCell(HSSFCell cell, CellType cellType) {
        if (cell == null) {
            return null;
        }
        switch (cellType) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                double numericCellValue = cell.getNumericCellValue();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return DateUtil.getJavaDate((double)numericCellValue, (boolean)false, (TimeZone)DEFAULT_TIME_ZONE);
                }
                return this.convertNumericToObject(numericCellValue);
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case BLANK: {
                return null;
            }
            case ERROR: {
                throw new IllegalArgumentException("Cell is of type error.");
            }
            case FORMULA: {
                CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                if (cachedFormulaResultType == CellType.FORMULA) {
                    throw new IllegalStateException("Cached cell type is again of type formular.");
                }
                return this.readCell(cell, cell.getCachedFormulaResultType());
            }
        }
        throw new IllegalStateException("Invalid cell type: " + cell.getCellType());
    }

    public Object readCell(int sheet, CoordinateInterface coord) {
        return this.readCell(sheet, coord.x(), coord.y());
    }

    private Object convertNumericToObject(double cellValue) {
        long cellValueRounded = Math.round(cellValue);
        if (Math.abs(cellValue - (double)cellValueRounded) < 1.0E-10) {
            if (Integer.MIN_VALUE <= cellValueRounded && cellValue <= 2.147483647E9) {
                return (int)cellValueRounded;
            }
            return cellValueRounded;
        }
        return cellValue;
    }

    @Override
    public <T> T readCell(int sheetNo, int x, int y, Class<T> clazz) {
        if (this.isEmpty(sheetNo, x, y)) {
            return null;
        }
        try {
            HSSFCell cell = this.workbook.getSheetAt(sheetNo).getRow(y).getCell(x);
            if (cell == null) {
                return null;
            }
            switch (cell.getCellType()) {
                case STRING: {
                    String str = cell.getStringCellValue();
                    if (clazz == String.class) {
                        return (T)str;
                    }
                    if (clazz == Integer.class) {
                        return (T)new Integer(str);
                    }
                    if (clazz == Long.class) {
                        return (T)new Long(str);
                    }
                    if (clazz == Boolean.class) {
                        return (T)new Boolean(str);
                    }
                    if (clazz == Date.class) {
                        SimpleDateFormat isoFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
                        isoFormat.setTimeZone(DEFAULT_TIME_ZONE);
                        return (T)isoFormat.parse(str);
                    }
                    throw new IllegalArgumentException("Invalid class '" + clazz + "'");
                }
                case NUMERIC: {
                    double dbl = cell.getNumericCellValue();
                    if (clazz == String.class) {
                        return (T)String.valueOf(dbl);
                    }
                    if (clazz == Integer.class) {
                        return (T)new Integer((int)dbl);
                    }
                    if (clazz == Long.class) {
                        return (T)new Long((long)dbl);
                    }
                    if (clazz == Date.class) {
                        return (T)DateUtil.getJavaDate((double)dbl);
                    }
                    throw new IllegalArgumentException("Invalid class '" + clazz + "'");
                }
                case BOOLEAN: {
                    boolean bool = cell.getBooleanCellValue();
                    if (clazz == String.class) {
                        return (T)String.valueOf(bool);
                    }
                    if (clazz == Integer.class) {
                        return (T)(bool ? Integer.valueOf(1) : Integer.valueOf(0));
                    }
                    if (clazz == Long.class) {
                        return (T)(bool ? Long.valueOf(1L) : Long.valueOf(0L));
                    }
                    throw new IllegalArgumentException("Invalid class '" + clazz + "'");
                }
                case BLANK: {
                    return null;
                }
                case ERROR: {
                    throw new IllegalArgumentException("Cell is of type error.");
                }
                case FORMULA: {
                    throw new IllegalArgumentException("Cell is of type formular.");
                }
            }
            throw new IllegalStateException("Invalid cell type: " + cell.getCellType());
        }
        catch (Exception e) {
            throw new RuntimeException("Access to cell (sheet=" + sheetNo + ", x=" + x + ", y=" + y + ") failed", e);
        }
    }

    public <T> T readCell(int sheet, CoordinateInterface coord, Class<T> clazz) {
        return this.readCell(sheet, coord.x(), coord.y(), clazz);
    }

    @Override
    public int noRows(int sheetNo) {
        return this.workbook.getSheetAt(sheetNo).getLastRowNum() + 1;
    }

    @Override
    public int noCols(int sheetNo) {
        short maxLastCellNum = 0;
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNo);
        for (int i = 0; i < this.noRows(sheetNo); ++i) {
            short lastCellNum;
            HSSFRow row = sheet.getRow(i);
            if (row == null || (lastCellNum = sheet.getRow(i).getLastCellNum()) <= maxLastCellNum) continue;
            maxLastCellNum = lastCellNum;
        }
        return maxLastCellNum;
    }

    @Override
    public String sheetName(int sheetNo) {
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNo);
        return sheet.getSheetName();
    }
}

