/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.staproma.spm;

import de.japrost.staproma.TaskState;
import de.japrost.staproma.spm.SpmFormat;
import de.japrost.staproma.task.AnonymousTask;
import de.japrost.staproma.task.FolderTask;
import de.japrost.staproma.task.LeafTask;
import de.japrost.staproma.task.Task;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleSpmFormat
implements SpmFormat {
    private final TaskState status;

    public SimpleSpmFormat(TaskState status) {
        this.status = status;
    }

    @Override
    public Task parseLines(List<String> lines) {
        FolderTask rootTask = new FolderTask(null, "Root)");
        this.parseLines(rootTask, lines);
        return rootTask;
    }

    @Override
    public void parseLines(Task rootTask, List<String> lines) {
        Pattern p = Pattern.compile("(#*) (.*)");
        int currentL = 0;
        Task currentT = rootTask;
        Task contentT = rootTask;
        for (String line : lines) {
            Matcher m = p.matcher(line);
            if (m.matches()) {
                FolderTask task;
                Task addTo;
                int level = m.group(1).length();
                if (currentL == level) {
                    addTo = currentT.getParent();
                    task = new FolderTask(addTo, m.group(2));
                    task.setState(this.status);
                    addTo.addChild(task);
                    currentT = task;
                    contentT = task;
                }
                if (currentL > level) {
                    addTo = currentT.getParent().getParent();
                    for (int l = 1; l < currentL - level; ++l) {
                        addTo = addTo.getParent();
                    }
                    task = new FolderTask(addTo, m.group(2));
                    task.setState(this.status);
                    addTo.addChild(task);
                    currentT = task;
                    contentT = task;
                }
                if (currentL < level) {
                    addTo = currentT;
                    for (int l = 1; l < level - currentL; ++l) {
                        AnonymousTask task2 = new AnonymousTask(addTo);
                        task2.setState(this.status);
                        addTo.addChild(task2);
                        addTo = task2;
                    }
                    task = new FolderTask(addTo, m.group(2));
                    task.setState(this.status);
                    addTo.addChild(task);
                    currentT = task;
                    contentT = task;
                }
                currentL = level;
                continue;
            }
            if (line.startsWith("* ")) {
                Task addTo = currentT;
                LeafTask task = new LeafTask(currentT, line.substring(2));
                task.setState(this.status);
                addTo.addChild(task);
                contentT = task;
                continue;
            }
            contentT.addContent(line);
        }
    }
}

