/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.staproma.renderer;

import de.japrost.staproma.TaskState;
import de.japrost.staproma.task.DirectoryTask;
import de.japrost.staproma.task.LeafTask;
import de.japrost.staproma.task.Task;
import java.io.IOException;
import java.io.Writer;

public class StatusTaskHtmlRenderer {
    public void render(Task root, TaskState status, Writer writer) throws IOException {
        this.walkSubTree(root, 0, new RenderState(), status, writer);
    }

    private void walkSubTree(Task task, int level, RenderState renderState, TaskState status, Writer writer) throws IOException {
        int myLevel = level + 1;
        if (task.isInState(status)) {
            if (level > 0) {
                this.printTask(task, level, renderState, writer);
            }
            RenderState localRenderState = new RenderState();
            for (Task subTask : task) {
                this.walkSubTree(subTask, myLevel, localRenderState, status, writer);
            }
            if (localRenderState.openul) {
                writer.append("</ul>\n");
            }
        }
    }

    private void printTask(Task task, int level, RenderState renderState, Writer writer) throws IOException {
        if (task instanceof LeafTask) {
            if (!renderState.openul) {
                renderState.openul = true;
                if (renderState.inBlock) {
                    writer.append("<h" + level + ">WEITERES</h" + level + ">\n");
                }
                writer.append("<ul>\n");
            }
            if (task.getPriority() > 0) {
                writer.append("  <li class='priority" + task.getPriority() + "'>" + task.getDescription() + "</li>\n");
            } else {
                writer.append("  <li>" + task.getDescription() + "</li>\n");
            }
        } else {
            if (renderState.openul) {
                writer.append("</ul>\n");
                renderState.openul = false;
            }
            renderState.inBlock = true;
            if (task instanceof DirectoryTask) {
                writer.append("<h" + level + ">");
                writer.append("<a href='" + ((DirectoryTask)task).getPath() + "'>");
                writer.append(task.getDescription());
                writer.append("</a>");
                writer.append("</h" + level + ">\n");
            } else {
                writer.append("<h" + level + ">" + task.getDescription() + "</h" + level + ">\n");
            }
        }
    }

    private class RenderState {
        boolean openul = false;
        boolean inBlock = false;

        private RenderState() {
        }
    }
}

