/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.staproma;

import de.japrost.staproma.TaskFileWalker;
import de.japrost.staproma.TaskState;
import de.japrost.staproma.renderer.ScheduledTaskHtmlRenderer;
import de.japrost.staproma.renderer.StatusTaskHtmlRenderer;
import de.japrost.staproma.task.FolderTask;
import de.japrost.staproma.task.LeafTask;
import de.japrost.staproma.task.Task;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.time.LocalDate;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class RenderStaProMa2 {
    private final File startDir;
    private final File outDir;
    private final IOFileFilter fileFilter;
    private final String currentFileName = "01_currentItems.html";
    private final String waitingFileName = "02_waitingItems.html";
    private final String scheduledFileName = "03_scheduledItems.html";
    private final String futureFileName = "10_futureItems.html";
    private final String somedayFileName = "20_somedayItems.html";
    private final String doneFileName = "99_doneItems.html";

    public RenderStaProMa2(File startDir, IOFileFilter fileFilter) {
        this(startDir, startDir, fileFilter);
    }

    public RenderStaProMa2(File startDir, File outDir, IOFileFilter fileFilter) {
        this.startDir = startDir;
        this.outDir = outDir;
        this.fileFilter = fileFilter;
        boolean log = false;
        if (!log) {
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }));
        }
    }

    public static void main(String[] args) throws IOException {
        IOFileFilter currentFilter = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), new RegexFileFilter("^\\d*_?current\\..*$", IOCase.SENSITIVE));
        IOFileFilter waitingFilter = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), new RegexFileFilter("^\\d*_?waiting\\..*$", IOCase.SENSITIVE));
        IOFileFilter scheduleFilter = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), new RegexFileFilter("^\\d*_?schedule\\..*$", IOCase.SENSITIVE));
        IOFileFilter futureFilter = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), new RegexFileFilter("^\\d*_?future\\..*$", IOCase.SENSITIVE));
        IOFileFilter somedayFilter = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), new RegexFileFilter("^\\d*_?someday\\..*$", IOCase.SENSITIVE));
        IOFileFilter doneFilter = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), new RegexFileFilter("^\\d*_?done\\..*$", IOCase.SENSITIVE));
        IOFileFilter gtdFilter = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), new RegexFileFilter("^\\d*_?gtd\\..*$", IOCase.SENSITIVE));
        IOFileFilter gtd2Filter = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), new RegexFileFilter("^([A-Z]+)-(\\d+)_(.*)\\.spm$", IOCase.SENSITIVE));
        IOFileFilter allFilter = FileFilterUtils.or(currentFilter, waitingFilter, scheduleFilter, futureFilter, somedayFilter, doneFilter, gtdFilter, gtd2Filter);
        File baseDir = new File("/home/uli/media/DSOne_home/01_ToDo/");
        File outDir = new File("/home/uli/media/DSOne_home/01_ToDo/");
        if (args.length > 0) {
            outDir = baseDir = new File(args[0]);
            System.err.println("Starting for " + baseDir.getAbsolutePath());
        }
        if (args.length > 1) {
            outDir = new File(args[1]);
            System.err.println("Writing to " + outDir.getAbsolutePath());
        }
        RenderStaProMa2 current = new RenderStaProMa2(baseDir, outDir, allFilter);
        current.doAll();
    }

    private void doAll() throws IOException {
        Task rootTask = this.crawlFiles();
        StatusTaskHtmlRenderer stw = new StatusTaskHtmlRenderer();
        this.writeFile(rootTask, stw, "Current", TaskState.CURRENT, "01_currentItems.html");
        this.writeFile(rootTask, stw, "Waiting", TaskState.WAITING, "02_waitingItems.html");
        LeafTask today = new LeafTask(rootTask, LocalDate.now().toString() + " +-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+-_-+");
        today.setState(TaskState.SCHEDULE);
        rootTask.addChild(today);
        this.writeScheduleFile(rootTask, "Scheduled", "03_scheduledItems.html");
        this.writeFile(rootTask, stw, "Future", TaskState.FUTURE, "10_futureItems.html");
        this.writeFile(rootTask, stw, "Someday", TaskState.SOMEDAY, "20_somedayItems.html");
        this.writeFile(rootTask, stw, "Done", TaskState.DONE, "99_doneItems.html");
        this.copyStyle();
    }

    private void writeScheduleFile(Task root, String title, String fileName) throws IOException {
        StringWriter writer = new StringWriter();
        this.writeHead(writer, title);
        ScheduledTaskHtmlRenderer scheduledTaskHtmlRenderer = new ScheduledTaskHtmlRenderer(root, writer);
        scheduledTaskHtmlRenderer.render();
        this.writeFoot(writer);
        this.writeFile(fileName, writer.toString());
    }

    private void writeFile(Task root, StatusTaskHtmlRenderer stw, String title, TaskState status, String fileName) throws IOException {
        StringWriter writer = new StringWriter();
        this.writeHead(writer, title);
        stw.render(root, status, writer);
        this.writeFoot(writer);
        this.writeFile(fileName, writer.toString());
    }

    private void writeHead(StringWriter writer, String title) {
        writer.append("<!DOCTYPE html>\n");
        writer.append("<html>");
        writer.append("<head>");
        writer.append("<title>" + title + "</title>");
        writer.append("<link type='text/css' href='style.css' rel='stylesheet'/>");
        writer.append("<meta http-equiv='content-type' content='text/html; charset=UTF-8'/>");
        writer.append("</head>");
        writer.append("<body>");
        writer.append("<div class='navigation'>");
        writer.append("<a href='01_currentItems.html'>Current</a> ");
        writer.append("<a href='02_waitingItems.html'>Waiting</a> ");
        writer.append("<a href='03_scheduledItems.html'>Scheduled</a> ");
        writer.append("<a href='10_futureItems.html'>Future</a> ");
        writer.append("<a href='20_somedayItems.html'>Someday</a> ");
        writer.append("<a href='99_doneItems.html'>Done</a> ");
        writer.append("</div>");
        writer.append("<hr/>");
        writer.append("<div class='title'>" + title + " Items</div>");
        writer.append("<hr/>");
    }

    private void writeFoot(StringWriter writer) {
        writer.append("<div class='generationTime'>" + new Date().toString() + "</div>");
        writer.append("</body>");
        writer.append("</html>");
    }

    private Task crawlFiles() throws IOException {
        FolderTask root = new FolderTask(null, "ROOT");
        TaskFileWalker fileWalker = new TaskFileWalker(root, this.startDir, this.fileFilter);
        fileWalker.crawl();
        return root;
    }

    private void writeFile(String fileName, String content) throws IOException {
        FileUtils.write(new File(this.outDir, fileName), content);
    }

    private void copyStyle() throws IOException {
        File srcCssFile = new File("src/main/resources/style.css");
        if (srcCssFile.canRead()) {
            File destCssFile = new File(this.outDir, "style.css");
            FileUtils.copyFile(srcCssFile, destCssFile);
        }
    }
}

