/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.staproma.task;

import de.japrost.staproma.TaskState;
import de.japrost.staproma.task.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstactTask
implements Task {
    protected Collection<Task> subTasks = new ArrayList<Task>();
    protected TaskState state;
    private final String description;
    private final Task parent;
    private final List<String> content = new ArrayList<String>();
    private short priority;

    protected AbstactTask(Task parent, String description) {
        this.parent = parent;
        this.description = description;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    @Override
    public boolean isInState(TaskState status) {
        String enter = "-> state " + this.getDescription() + ": " + (Object)((Object)this.state);
        String leave = "<- state " + this.getDescription() + ": ";
        System.out.println(enter);
        if (status == null) {
            System.out.println(leave + "TRUE on null");
            return true;
        }
        if (status.equals((Object)this.state)) {
            System.out.println(leave + "TRUE on equals");
            return true;
        }
        for (Task subTask : this.subTasks) {
            if (!subTask.isInState(status)) continue;
            System.out.println(leave + "TRUE on sub");
            return true;
        }
        System.out.println(leave + "FALSE fallback");
        return false;
    }

    @Override
    public Iterator<Task> iterator() {
        return this.subTasks.iterator();
    }

    @Override
    public boolean hasChildren() {
        return !this.subTasks.isEmpty();
    }

    @Override
    public void addChild(Task task) {
        this.subTasks.add(task);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Task getParent() {
        return this.parent;
    }

    public List<String> getContent() {
        return this.content;
    }

    @Override
    public void addContent(String line) {
        this.content.add(line);
    }

    @Override
    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short priority) {
        this.priority = priority;
    }
}

