/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.staproma.spm;

import de.japrost.staproma.TaskState;
import de.japrost.staproma.spm.SpmFormat;
import de.japrost.staproma.task.AbstactTask;
import de.japrost.staproma.task.AnonymousTask;
import de.japrost.staproma.task.FolderTask;
import de.japrost.staproma.task.LeafTask;
import de.japrost.staproma.task.Task;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GtdSpmFormat
implements SpmFormat {
    private static final Pattern TOPIC_PATTERN = Pattern.compile("(#*) (.*)");
    private static final Pattern ACTION_PATTERN = Pattern.compile("\\* \\(([!/?#:@\\d\\f])\\) (.*)");

    @Override
    public Task parseLines(List<String> lines) {
        FolderTask rootTask = new FolderTask(null, "Root)");
        this.parseLines(rootTask, lines);
        return rootTask;
    }

    @Override
    public void parseLines(Task rootTask, List<String> lines) {
        int currentL = 0;
        Task currentT = rootTask;
        Task contentT = rootTask;
        for (String line : lines) {
            AbstactTask task;
            Task addTo;
            Matcher topicMatcher = TOPIC_PATTERN.matcher(line);
            if (topicMatcher.matches()) {
                int level = topicMatcher.group(1).length();
                System.out.println("#> Going for " + topicMatcher.group(2) + " on " + level);
                if (currentL == level) {
                    addTo = currentT.getParent();
                    task = new FolderTask(addTo, topicMatcher.group(2));
                    addTo.addChild(task);
                    currentT = task;
                    contentT = task;
                }
                if (currentL > level) {
                    addTo = currentT.getParent().getParent();
                    for (int l = 1; l < currentL - level; ++l) {
                        addTo = addTo.getParent();
                    }
                    task = new FolderTask(addTo, topicMatcher.group(2));
                    addTo.addChild(task);
                    currentT = task;
                    contentT = task;
                }
                if (currentL < level) {
                    addTo = currentT;
                    for (int l = 1; l < level - currentL; ++l) {
                        AnonymousTask task2 = new AnonymousTask(addTo);
                        addTo.addChild(task2);
                        addTo = task2;
                    }
                    task = new FolderTask(addTo, topicMatcher.group(2));
                    addTo.addChild(task);
                    currentT = task;
                    contentT = task;
                }
                currentL = level;
                continue;
            }
            Matcher stepMatcher = ACTION_PATTERN.matcher(line);
            if (stepMatcher.matches()) {
                LeafTask task3;
                System.out.println("*> Going for '" + line.substring(2) + "' with '" + stepMatcher.group(1) + "' on " + currentL);
                String symbol = stepMatcher.group(1);
                TaskState state = null;
                short priority = 0;
                if ("!".equals(symbol)) {
                    state = TaskState.CURRENT;
                    priority = 1;
                } else {
                    state = "@".equals(symbol) ? TaskState.SCHEDULE : ("/".equals(symbol) ? TaskState.DONE : ("?".equals(symbol) ? TaskState.SOMEDAY : ("#".equals(symbol) ? TaskState.FUTURE : (":".equals(symbol) ? TaskState.WAITING : ((priority = this.parseNumber(symbol)) != 0 ? TaskState.CURRENT : null)))));
                }
                if (state == null) {
                    task3 = new LeafTask(currentT, line.substring(2));
                    task3.setState(TaskState.CURRENT);
                } else {
                    task3 = new LeafTask(currentT, stepMatcher.group(2));
                    task3.setState(state);
                    task3.setPriority(priority);
                }
                Task addTo2 = currentT;
                addTo2.addChild(task3);
                contentT = task3;
                continue;
            }
            if (line.startsWith("* ")) {
                System.out.println("-> Going for " + line.substring(2) + " on " + currentL);
                addTo = currentT;
                task = new LeafTask(currentT, line.substring(2));
                task.setState(TaskState.CURRENT);
                addTo.addChild(task);
                contentT = task;
                continue;
            }
            System.out.println(" > Going for " + line + " on " + currentL);
            contentT.addContent(line);
        }
    }

    private short parseNumber(String symbol) {
        short result = 0;
        try {
            result = Short.parseShort(symbol);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }
}

