/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.staproma.renderer;

import de.japrost.staproma.TaskState;
import de.japrost.staproma.task.DirectoryTask;
import de.japrost.staproma.task.LeafTask;
import de.japrost.staproma.task.Task;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ScheduledTaskHtmlRenderer {
    private final Task rootTask;
    private final Writer writer;
    private List<LeafTask> leafs;

    public ScheduledTaskHtmlRenderer(Task rootTask, Writer writer) {
        if (rootTask == null | writer == null) {
            throw new IllegalArgumentException("Task (" + rootTask + ") or Writer (" + writer + ") must not be null");
        }
        this.rootTask = rootTask;
        this.writer = writer;
        this.leafs = new ArrayList<LeafTask>();
    }

    public void render() throws IOException {
        this.writer.write("<dl>\n");
        if (this.rootTask instanceof LeafTask) {
            this.render((LeafTask)this.rootTask);
        } else {
            this.collectFromTree(this.rootTask);
            this.leafs.sort(new Comparator<LeafTask>(){

                @Override
                public int compare(LeafTask o1, LeafTask o2) {
                    return o1.getDescription().compareTo(o2.getDescription());
                }
            });
            this.renderLeafs();
        }
        this.writer.write("</dl>\n");
    }

    private void collectFromTree(Task treeRoot) throws IOException {
        for (Task subTask : treeRoot) {
            if (!subTask.isInState(TaskState.SCHEDULE)) continue;
            if (subTask instanceof LeafTask) {
                this.leafs.add((LeafTask)subTask);
                continue;
            }
            this.collectFromTree(subTask);
        }
    }

    private void renderLeafs() throws IOException {
        for (LeafTask leaf : this.leafs) {
            this.render(leaf);
        }
    }

    private void render(LeafTask leafTask) throws IOException {
        String parentString = this.composeParentPath(leafTask);
        String[] split = leafTask.getDescription().split(" ", 2);
        this.writer.write("  <dt>" + split[0] + "</dt>\n");
        this.writer.write("  <dd>" + split[1] + parentString + "</dd>\n");
        this.writer.write("\n");
    }

    private String composeParentPath(Task leafTask) {
        Task parent = leafTask.getParent();
        String parentString = "";
        if (parent != null && parent.getParent() != null) {
            parentString = parent instanceof DirectoryTask ? " : <a href='" + ((DirectoryTask)parent).getPath() + "'>" + parent.getDescription() + "</a>" : " : " + parent.getDescription();
            parentString = parentString + this.composeParentPath(parent);
        }
        return parentString;
    }
}

