/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.staproma;

import de.japrost.staproma.spm.DefaultSpmFactory;
import de.japrost.staproma.spm.SpmFormat;
import de.japrost.staproma.spm.SpmFormatFactory;
import de.japrost.staproma.task.DirectoryTask;
import de.japrost.staproma.task.Task;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class TaskFileWalker
extends DirectoryWalker<String> {
    private static final PrintStream OUT = System.out;
    private final File startDirectory;
    private final boolean filterCompleted;
    private final SpmFormatFactory spmFormatFactory;
    private static final Pattern MINMAL_DIR_PATTERN = Pattern.compile("^([A-Z]*)$");
    private static final Pattern NUMBER_DIR_PATTERN = Pattern.compile("^([A-Z]*)-(\\d*)$");
    private static final Pattern NAME_DIR_PATTERN = Pattern.compile("^([A-Z]*)_(.*$)");
    private static final Pattern FULL_DIR_PATTERN = Pattern.compile("^([A-Z]*)-(\\d*)_(.*$)");
    private static final Pattern FILE_STATUS_PATTERN = Pattern.compile("^\\d*_?(.*)\\..*$");
    private int level = 0;
    private Task currentTask;

    public TaskFileWalker(Task rootTask, File startDirectory, IOFileFilter fileFilter) {
        this(rootTask, startDirectory, fileFilter, new DefaultSpmFactory(), true);
    }

    public TaskFileWalker(Task rootTask, File startDirectory, IOFileFilter fileFilter, SpmFormatFactory spmFormatFactory, boolean filterCompleted) {
        super(FileFilterUtils.directoryFileFilter(), fileFilter, -1);
        this.startDirectory = startDirectory;
        this.filterCompleted = filterCompleted;
        this.currentTask = rootTask;
        this.spmFormatFactory = spmFormatFactory;
    }

    public void crawl() throws IOException {
        this.walk(this.startDirectory, null);
    }

    @Override
    protected boolean handleDirectory(File directory, int depth, Collection<String> results) throws IOException {
        OUT.println("Handle DIR :" + directory);
        if (!directory.equals(this.startDirectory)) {
            String dirName;
            if (this.filterCompleted && this.containsCompleted(directory)) {
                OUT.println("-> Completed: " + directory.getAbsolutePath());
                return false;
            }
            String description = dirName = directory.getName();
            boolean match = false;
            Matcher matcher = MINMAL_DIR_PATTERN.matcher(dirName);
            if (matcher.matches()) {
                match = true;
            }
            if ((matcher = NUMBER_DIR_PATTERN.matcher(dirName)).matches()) {
                match = true;
            }
            if ((matcher = NAME_DIR_PATTERN.matcher(dirName)).matches()) {
                match = true;
                description = matcher.group(2).replace('_', ' ');
            }
            if ((matcher = FULL_DIR_PATTERN.matcher(dirName)).matches()) {
                match = true;
                description = matcher.group(1) + "-" + matcher.group(2) + " " + matcher.group(3).replace('_', ' ');
            }
            if (match) {
                OUT.println("   DO THE STUFF and ignore results");
                String path = directory.getPath();
                String startDirPath = this.startDirectory.getPath();
                String relativePath = "." + path.substring(startDirPath.length());
                if (depth == this.level) {
                    OUT.println("SAME");
                    Task addTo = this.currentTask.getParent();
                    DirectoryTask task = new DirectoryTask(addTo, relativePath, description);
                    addTo.addChild(task);
                    this.currentTask = task;
                } else if (depth < this.level) {
                    OUT.println("PARENT");
                    Task addTo = this.currentTask.getParent().getParent();
                    DirectoryTask task = new DirectoryTask(addTo, relativePath, description);
                    addTo.addChild(task);
                    this.currentTask = task;
                } else {
                    OUT.println("SUB");
                    Task addTo = this.currentTask;
                    DirectoryTask task = new DirectoryTask(addTo, relativePath, description);
                    addTo.addChild(task);
                    this.currentTask = task;
                }
                this.level = depth;
                return true;
            }
            OUT.println("-> Ignoring: " + directory.getAbsolutePath());
            return false;
        }
        return true;
    }

    @Override
    protected void handleFile(File file, int depth, Collection<String> results) throws IOException {
        OUT.println("Handle FILE:" + file);
        Matcher m = FILE_STATUS_PATTERN.matcher(file.getName());
        String status = "CURRENT";
        if (m.matches()) {
            status = m.group(1).toUpperCase();
            OUT.println(status);
        } else {
            OUT.println("This should not happen");
        }
        SpmFormat spmFormat = this.spmFormatFactory.construct(status);
        List<String> lines = this.readLines(file);
        spmFormat.parseLines(this.currentTask, lines);
    }

    List<String> readLines(File file) throws IOException {
        return IOUtils.readLines(new FileInputStream(file));
    }

    @Override
    protected File[] filterDirectoryContents(File directory, int depth, File[] inFiles) throws IOException {
        OUT.println("filterDirectoryContents " + directory);
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<File> dirs = new ArrayList<File>();
        for (File f : inFiles) {
            if (f.isFile()) {
                files.add(f);
                continue;
            }
            dirs.add(f);
        }
        Collections.sort(files);
        Collections.sort(dirs);
        files.addAll(dirs);
        return files.toArray(new File[0]);
    }

    private boolean containsCompleted(File directory) {
        OUT.println("containsCompleted " + directory);
        IOFileFilter completedFilter = FileFilterUtils.and(FileFilterUtils.fileFileFilter(), new RegexFileFilter("^\\d*_?completed\\.?.*$", IOCase.SENSITIVE));
        return FileUtils.listFiles(directory, completedFilter, null).size() > 0;
    }
}

