/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.jabudget.vaadin.spring;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.router.Route;
import de.japrost.jabudget.domain.DomainException;
import de.japrost.jabudget.domain.account.Account;
import de.japrost.jabudget.service.AccountService;
import de.japrost.jabudget.service.SerializationService;
import java.io.Serializable;
import java.util.Collection;

@Route(value="")
public class JaBudGetUI
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    private final transient AccountService accountService;
    private ListDataProvider<Account> accountData;
    private Account selectedAccount;
    private Button newAccount;
    private Button clear;
    private Button delete;
    private TextField newId;
    private TextField newName;
    private final transient SerializationService serializationService;
    private Button export;
    private Button impoort;

    public JaBudGetUI(AccountService accountService, SerializationService serializationService) {
        this.accountService = accountService;
        this.serializationService = serializationService;
        this.setSizeFull();
        this.add(new Component[]{this.initAccountOverview()});
        this.add(new Component[]{this.initAccountForm()});
        this.add(new Component[]{this.initSerialization()});
    }

    private VerticalLayout initAccountOverview() {
        VerticalLayout layout = new VerticalLayout();
        Grid accounts = new Grid(Account.class);
        accounts.setColumns(new String[]{"id", "name"});
        this.accountData = new ListDataProvider((Collection)this.accountService.retrieveAll());
        accounts.setDataProvider(this.accountData);
        accounts.addSelectionListener(this::itemClicked);
        layout.add(new Component[]{accounts});
        return layout;
    }

    private void itemClicked(SelectionEvent<Grid<Account>, Account> e) {
        this.selectedAccount = (Account)e.getFirstSelectedItem().get();
        this.newId.setValue(this.selectedAccount.getId());
        this.newName.setValue(this.selectedAccount.getName());
        this.newAccount.setText("Update");
        this.delete.setEnabled(true);
    }

    private FormLayout initAccountForm() {
        FormLayout newAccountLayout = new FormLayout();
        this.newId = new TextField();
        this.newId.setLabel("id");
        this.newId.setRequiredIndicatorVisible(true);
        this.newId.addValueChangeListener(this::newIdValueChanged);
        newAccountLayout.add(new Component[]{this.newId});
        this.newName = new TextField();
        this.newName.setLabel("name");
        newAccountLayout.add(new Component[]{this.newName});
        this.newAccount = new Button();
        this.newAccount.setText("New");
        this.newAccount.setEnabled(false);
        this.newAccount.addClickListener(this::createNewAccount);
        newAccountLayout.add(new Component[]{this.newAccount});
        this.clear = new Button();
        this.clear.setText("Clear");
        this.clear.setEnabled(false);
        this.clear.addClickListener(this::clearAccount);
        newAccountLayout.add(new Component[]{this.clear});
        this.delete = new Button();
        this.delete.setText("Delete");
        this.delete.setEnabled(false);
        this.delete.addClickListener(this::deleteAccount);
        newAccountLayout.add(new Component[]{this.delete});
        return newAccountLayout;
    }

    private void clearAccount(ClickEvent<Button> event) {
        this.newId.clear();
        this.newName.clear();
        this.newAccount.setText("New");
    }

    private void deleteAccount(ClickEvent<Button> event) {
        Boolean erased = this.accountService.erase(this.newId.getValue());
        if (erased.booleanValue()) {
            this.accountData.getItems().remove(this.selectedAccount);
            this.accountData.refreshAll();
            this.newId.clear();
            this.newName.clear();
            this.newAccount.setText("New");
        }
    }

    private void createNewAccount(ClickEvent<Button> event) {
        try {
            if (this.newAccount.getText().equals("New")) {
                Account account = this.accountService.create(Account.Builder.builder((String)this.newId.getValue()).setName(this.newName.getValue()).build());
                this.accountData.getItems().add(account);
            } else {
                Account account = this.accountService.update(Account.Builder.builder((String)this.newId.getValue()).setName(this.newName.getValue()).build());
                this.accountData.getItems().remove(account);
                this.accountData.getItems().add(account);
            }
        }
        catch (DomainException e) {
            return;
        }
        this.newId.clear();
        this.newName.clear();
        this.newAccount.setText("New");
        this.accountData.refreshAll();
    }

    private void newIdValueChanged(HasValue.ValueChangeEvent<String> event) {
        if (((String)event.getValue()).length() == 0) {
            this.newAccount.setEnabled(false);
            this.clear.setEnabled(false);
            this.delete.setEnabled(false);
            this.selectedAccount = null;
        } else {
            this.newAccount.setEnabled(true);
            this.clear.setEnabled(true);
        }
    }

    private VerticalLayout initSerialization() {
        VerticalLayout layout = new VerticalLayout();
        this.impoort = new Button();
        this.impoort.setText("Import");
        this.impoort.addClickListener((ComponentEventListener & Serializable)e -> {
            this.serializationService.deserialize();
            this.reloadAccounts();
        });
        layout.add(new Component[]{this.impoort});
        this.export = new Button();
        this.export.setText("Export");
        this.export.addClickListener((ComponentEventListener & Serializable)e -> this.serializationService.serialize());
        layout.add(new Component[]{this.export});
        return layout;
    }

    private void reloadAccounts() {
        this.accountData.getItems().clear();
        this.accountData.getItems().addAll(this.accountService.retrieveAll());
        this.accountData.refreshAll();
    }
}

