/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.jabudget.vaadin.spring;

import com.vaadin.data.HasValue;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.VaadinRequest;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import de.japrost.jabudget.domain.DomainException;
import de.japrost.jabudget.domain.account.Account;
import de.japrost.jabudget.service.AccountService;
import de.japrost.jabudget.service.SerializationService;
import java.io.Serializable;
import java.util.Collection;

@SpringUI
public class JaBudGetUI
extends UI {
    private static final long serialVersionUID = 1L;
    private final transient AccountService accountService;
    private ListDataProvider<Account> accountData;
    private Account selectedAccount;
    private Button newAccount;
    private Button clear;
    private Button delete;
    private TextField newId;
    private TextField newName;
    private final transient SerializationService serializationService;
    private Button export;
    private Button impoort;

    public JaBudGetUI(AccountService accountService, SerializationService serializationService) {
        this.accountService = accountService;
        this.serializationService = serializationService;
    }

    protected void init(VaadinRequest request) {
        HorizontalLayout mainLayout = new HorizontalLayout();
        this.setContent((Component)mainLayout);
        mainLayout.setSizeFull();
        mainLayout.addComponent((Component)this.initAccountOverview());
        mainLayout.addComponent((Component)this.initAccountForm());
        mainLayout.addComponent((Component)this.initSerialization());
    }

    private VerticalLayout initAccountOverview() {
        VerticalLayout layout = new VerticalLayout();
        Grid accounts = new Grid(Account.class);
        accounts.setCaption("Accounts");
        accounts.setColumns(new String[]{"id", "name"});
        this.accountData = new ListDataProvider((Collection)this.accountService.retrieveAll());
        accounts.setDataProvider(this.accountData);
        accounts.addItemClickListener(this::itemClicked);
        layout.addComponent((Component)accounts);
        return layout;
    }

    private void itemClicked(Grid.ItemClick<Account> e) {
        this.selectedAccount = (Account)e.getItem();
        this.newId.setValue(this.selectedAccount.getId());
        this.newName.setValue(this.selectedAccount.getName());
        this.newAccount.setCaption("Update");
        this.delete.setEnabled(true);
    }

    private FormLayout initAccountForm() {
        FormLayout newAccountLayout = new FormLayout();
        this.newId = new TextField();
        this.newId.setCaption("id");
        this.newId.setRequiredIndicatorVisible(true);
        this.newId.addValueChangeListener(this::newIdValueChanged);
        newAccountLayout.addComponent((Component)this.newId);
        this.newName = new TextField();
        this.newName.setCaption("name");
        newAccountLayout.addComponent((Component)this.newName);
        this.newAccount = new Button();
        this.newAccount.setCaption("New");
        this.newAccount.setEnabled(false);
        this.newAccount.addClickListener(this::createNewAccount);
        newAccountLayout.addComponent((Component)this.newAccount);
        this.clear = new Button();
        this.clear.setCaption("Clear");
        this.clear.setEnabled(false);
        this.clear.addClickListener(this::clearAccount);
        newAccountLayout.addComponent((Component)this.clear);
        this.delete = new Button();
        this.delete.setCaption("Delete");
        this.delete.setEnabled(false);
        this.delete.addClickListener(this::deleteAccount);
        newAccountLayout.addComponent((Component)this.delete);
        return newAccountLayout;
    }

    private void clearAccount(Button.ClickEvent event) {
        this.newId.clear();
        this.newName.clear();
        this.newAccount.setCaption("New");
    }

    private void deleteAccount(Button.ClickEvent event) {
        Boolean erased = this.accountService.erase(this.newId.getValue());
        if (erased.booleanValue()) {
            this.accountData.getItems().remove(this.selectedAccount);
            this.accountData.refreshAll();
            this.newId.clear();
            this.newName.clear();
            this.newAccount.setCaption("New");
        }
    }

    private void createNewAccount(Button.ClickEvent event) {
        try {
            if (this.newAccount.getCaption().equals("New")) {
                Account account = this.accountService.create(Account.Builder.builder((String)this.newId.getValue()).setName(this.newName.getValue()).build());
                this.accountData.getItems().add(account);
            } else {
                Account account = this.accountService.update(Account.Builder.builder((String)this.newId.getValue()).setName(this.newName.getValue()).build());
                this.accountData.getItems().remove(account);
                this.accountData.getItems().add(account);
            }
        }
        catch (DomainException e) {
            return;
        }
        this.newId.clear();
        this.newName.clear();
        this.newAccount.setCaption("New");
        this.accountData.refreshAll();
    }

    private void newIdValueChanged(HasValue.ValueChangeEvent<String> event) {
        if (((String)event.getValue()).length() == 0) {
            this.newAccount.setEnabled(false);
            this.clear.setEnabled(false);
            this.delete.setEnabled(false);
            this.selectedAccount = null;
        } else {
            this.newAccount.setEnabled(true);
            this.clear.setEnabled(true);
        }
    }

    private VerticalLayout initSerialization() {
        VerticalLayout layout = new VerticalLayout();
        this.impoort = new Button();
        this.impoort.setCaption("Import");
        this.impoort.addClickListener((Button.ClickListener & Serializable)e -> {
            this.serializationService.deserialize();
            this.reloadAccounts();
        });
        layout.addComponent((Component)this.impoort);
        this.export = new Button();
        this.export.setCaption("Export");
        this.export.addClickListener((Button.ClickListener & Serializable)e -> this.serializationService.serialize());
        layout.addComponent((Component)this.export);
        return layout;
    }

    private void reloadAccounts() {
        this.accountData.getItems().clear();
        this.accountData.getItems().addAll(this.accountService.retrieveAll());
        this.accountData.refreshAll();
    }
}

