/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.jabudget.repository.inmemory;

import de.japrost.jabudget.domain.DomainException;
import de.japrost.jabudget.domain.DomainFailure;
import de.japrost.jabudget.domain.account.Account;
import de.japrost.jabudget.domain.account.Entry;
import de.japrost.jabudget.domain.account.EntryBuilder;
import de.japrost.jabudget.repository.AccountRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class InMemoryAccountRepository
implements AccountRepository {
    private final Map<String, Account> storage = new HashMap<String, Account>();
    private final Map<String, Collection<Entry>> entryStorage = new HashMap<String, Collection<Entry>>();

    @Override
    public Account create(Account account) throws DomainException {
        if (this.storage.containsKey(account.getId())) {
            throw new DomainException(DomainFailure.DUPLICATE_ENTITY);
        }
        return this.putInStoreDefensively(account);
    }

    @Override
    public Account update(Account account) throws DomainException {
        if (!this.storage.containsKey(account.getId())) {
            throw new DomainException(DomainFailure.MISSING_ENTITY);
        }
        return this.putInStoreDefensively(account);
    }

    @Override
    public void replaceAll(Set<Account> accounts) {
        this.storage.clear();
        this.entryStorage.clear();
        accounts.forEach(this::putInStoreDefensively);
    }

    private Account putInStoreDefensively(Account account) {
        Account accountToStore = new Account.Builder(account).build();
        this.storage.put(account.getId(), accountToStore);
        if (!this.entryStorage.containsKey(account.getId())) {
            this.entryStorage.put(account.getId(), new ArrayList());
        }
        return new Account.Builder(account).build();
    }

    @Override
    public Optional<Account> findById(String id) {
        return Account.Builder.builder((Account)this.storage.get(id)).buildOptional();
    }

    @Override
    public Set<Account> findAll() {
        return this.storage.values().stream().map(account -> new Account.Builder(account).build()).collect(Collectors.toSet());
    }

    @Override
    public Boolean delete(String accountId) {
        this.storage.remove(accountId);
        this.entryStorage.remove(accountId);
        return Boolean.TRUE;
    }

    @Override
    public Entry create(Entry entry) throws DomainException {
        Collection<Entry> entries = this.entryStorage.get(entry.getAccountId());
        if (Objects.isNull(entries)) {
            throw new DomainException(DomainFailure.MISSING_ENTITY_REFERENCE);
        }
        if (entries.contains(entry)) {
            throw new DomainException(DomainFailure.DUPLICATE_ENTITY);
        }
        return this.putInStoreDefensively(entries, entry);
    }

    private Entry putInStoreDefensively(Collection<Entry> entries, Entry value) {
        Entry toStore = EntryBuilder.builder((Entry)value).build();
        entries.add(toStore);
        return EntryBuilder.builder((Entry)toStore).build();
    }
}

