/*
 * Decompiled with CFR 0.152.
 */
package de.japrost.jabudget.repository.inmemory;

import de.japrost.jabudget.domain.DomainException;
import de.japrost.jabudget.domain.DomainFailure;
import de.japrost.jabudget.domain.account.Account;
import de.japrost.jabudget.domain.fixtures.account.AccountFixtureValues;
import de.japrost.jabudget.domain.fixtures.account.AccountFixtures;
import de.japrost.jabudget.repository.inmemory.InMemoryAccountRepository;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class InMemoryAccountRepositoryTest
implements AccountFixtureValues {
    private InMemoryAccountRepository cut;
    private final AccountFixtures accountFixtures = new AccountFixtures();
    private Account defaultAccount;

    @Before
    public void setUp() {
        this.cut = new InMemoryAccountRepository();
        this.defaultAccount = this.accountFixtures.createDefault();
    }

    @Test
    public void create_doesNotReturnGivenInstance() throws Exception {
        Account actual = this.cut.create(this.defaultAccount);
        Assertions.assertThat((Object)actual).isEqualTo((Object)this.defaultAccount);
        Assertions.assertThat((Object)actual).isNotSameAs((Object)this.defaultAccount);
    }

    @Test
    public void create_doesNotStoreGivenInstance() throws Exception {
        this.cut.create(this.defaultAccount);
        this.defaultAccount.setName("account-alt-name");
        Account actual = (Account)this.cut.findById("account-def-id").get();
        Assertions.assertThat((String)actual.getName()).isEqualTo((Object)"account-def-name");
    }

    @Test
    public void create_doesNotStoreDuplicates() throws Exception {
        this.cut.create(this.defaultAccount);
        Assertions.assertThatExceptionOfType(DomainException.class).isThrownBy(() -> this.cut.create(this.defaultAccount)).matches(p -> p.getFailure() == DomainFailure.DUPLICATE_ENTITY);
    }

    @Test
    public void update_updates() throws Exception {
        this.cut.create(this.defaultAccount);
        this.defaultAccount.setName("account-alt-name");
        this.cut.update(this.defaultAccount);
        Account actual = (Account)this.cut.findById("account-def-id").get();
        Assertions.assertThat((String)actual.getName()).isEqualTo((Object)"account-alt-name");
    }

    @Test
    public void update_doesNotStoreMissing() throws Exception {
        Assertions.assertThatExceptionOfType(DomainException.class).isThrownBy(() -> this.cut.update(this.defaultAccount)).matches(p -> p.getFailure() == DomainFailure.MISSING_ENTITY);
    }

    @Test
    public void replaceAll_replacesAll() throws Exception {
        this.cut.create(this.defaultAccount);
        this.cut.replaceAll(Set.of(this.accountFixtures.createAlternate()));
        Assertions.assertThat((Optional)this.cut.findById("account-def-id")).isEmpty();
        Assertions.assertThat((Iterable)this.cut.findAll()).hasSize(1);
        Assertions.assertThat((Optional)this.cut.findById("account-alt-id")).contains((Object)this.accountFixtures.createAlternate());
    }
}

