/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.platform.mac;

import de.jangassen.exception.LifecycleException;
import de.jangassen.jfa.JavaToObjc;
import de.jangassen.jfa.ObjcToJava;
import de.jangassen.jfa.appkit.NSAppearance;
import de.jangassen.jfa.appkit.NSApplication;
import de.jangassen.jfa.appkit.NSApplicationDelegate;
import de.jangassen.jfa.appkit.NSMenu;
import de.jangassen.jfa.appkit.NSMenuItem;
import de.jangassen.jfa.appkit.NSObject;
import de.jangassen.jfa.appkit.NSPoint;
import de.jangassen.jfa.appkit.NSStatusBar;
import de.jangassen.jfa.appkit.NSStatusBarButton;
import de.jangassen.jfa.appkit.NSStatusItem;
import de.jangassen.jfa.appkit.NSUserDefaults;
import de.jangassen.jfa.appkit.NSWindow;
import de.jangassen.jfa.appkit.NSWorkspace;
import de.jangassen.jfa.cleanup.NSCleaner;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import de.jangassen.listener.FirstWindowShowingEventListener;
import de.jangassen.model.AppearanceMode;
import de.jangassen.platform.NativeAdapter;
import de.jangassen.platform.mac.ApplicationDelegateWithMenu;
import de.jangassen.platform.mac.convert.ImageConverter;
import de.jangassen.platform.mac.convert.MenuConverter;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Menu;
import javafx.scene.input.MouseEvent;

public class MacNativeAdapter
implements NativeAdapter {
    private static MacNativeAdapter instance;
    private final NSApplication sharedApplication = NSApplication.sharedApplication();
    private final NSWorkspace sharedWorkspace = NSWorkspace.sharedWorkspace();
    private boolean forceQuitOnCmdQ = true;
    private Menu applicationMenu;
    private Menu trayMenu;
    private Menu dockIconMenu;
    private ApplicationDelegateWithMenu applicationDelegate;
    private NSStatusItem nsStatusItem;
    private FirstWindowShowingEventListener firstWindowShowingEventListener = null;

    private MacNativeAdapter() {
    }

    public static MacNativeAdapter getInstance() {
        if (instance == null) {
            instance = new MacNativeAdapter();
        }
        return instance;
    }

    public static boolean isAvailable() {
        return Foundation.isAvailable();
    }

    @Override
    public void setMenuBar(List<Menu> menus) {
        NSMenu menu = NSMenu.alloc().init();
        menus.stream().map(this::getMenuBarItem).forEach(arg_0 -> ((NSMenu)menu).addItem(arg_0));
        NSApplication.sharedApplication().setMainMenu(menu);
    }

    private NSMenuItem getMenuBarItem(Menu menu) {
        NSMenu nsMenu = MenuConverter.convert(menu);
        NSMenuItem wrapperItem = NSMenuItem.alloc().init();
        wrapperItem.setSubmenu(nsMenu);
        NSCleaner.register((Object)menu, (NSObject)wrapperItem);
        return wrapperItem;
    }

    @Override
    public void setApplicationMenu(Menu menu) {
        NSMenu nsMenu = this.sharedApplication.mainMenu();
        if (nsMenu == null || nsMenu.numberOfItems() == 0L) {
            this.setApplicationMenuWhenAvailable(menu);
        } else {
            this.setApplicationMenuImmediately(menu, nsMenu);
        }
    }

    private void setApplicationMenuImmediately(Menu menu, NSMenu nsMenu) {
        NSMenuItem mainMenu = NSMenuItem.alloc().initWithTitle("", null, "");
        mainMenu.setSubmenu(MenuConverter.convert(menu));
        nsMenu.removeItemAtIndex(0);
        nsMenu.insertItem(mainMenu, 0);
        this.sharedApplication.setAppearance(NSAppearance.appearanceNamed((NSAppearance.NSAppearanceName)NSAppearance.NSAppearanceName.NSAppearanceNameVibrantDark));
        this.applicationMenu = menu;
    }

    private void setApplicationMenuWhenAvailable(Menu menu) {
        if (this.firstWindowShowingEventListener == null) {
            this.firstWindowShowingEventListener = new FirstWindowShowingEventListener();
        }
        if (this.firstWindowShowingEventListener.isCompleted()) {
            throw new LifecycleException("Application menu is not initialized");
        }
        this.firstWindowShowingEventListener.setAction(() -> this.setApplicationMenu(menu));
    }

    @Override
    public void hide() {
        this.sharedApplication.hide(ID.NIL);
    }

    @Override
    public void hideOtherApplications() {
        this.sharedWorkspace.hideOtherApplications();
    }

    @Override
    public void showAllWindows() {
        this.sharedApplication.unhide(ID.NIL);
    }

    @Override
    public void quit() {
        if (this.forceQuitOnCmdQ) {
            Platform.exit();
        }
    }

    @Override
    public void setForceQuitOnCmdQ(boolean forceQuit) {
        this.forceQuitOnCmdQ = forceQuit;
    }

    @Override
    public void setTrayMenu(Menu menu) {
        NSStatusBar nsStatusBar = NSStatusBar.systemStatusBar();
        if (menu != null) {
            if (this.nsStatusItem == null) {
                this.nsStatusItem = this.createNewTrayMenu(nsStatusBar);
            }
            ImageConverter.convert(menu.getGraphic()).ifPresent(arg_0 -> ((NSStatusBarButton)this.nsStatusItem.button()).setImage(arg_0));
            NSMenu convertedMenu = MenuConverter.convert(menu);
            this.nsStatusItem.setMenu(convertedMenu);
            this.trayMenu = menu;
        } else if (this.nsStatusItem != null) {
            this.removeTrayMenu(nsStatusBar);
        }
    }

    private NSStatusItem createNewTrayMenu(NSStatusBar nsStatusBar) {
        NSStatusItem statusItem = nsStatusBar.statusItemWithLength(NSStatusBar.NSSquareStatusItemLength);
        ID statusItemId = ObjcToJava.toID((Object)statusItem);
        Foundation.cfRetain((ID)statusItemId);
        NSCleaner.register((Object)statusItem, (ID)statusItemId);
        return statusItem;
    }

    private void removeTrayMenu(NSStatusBar nsStatusBar) {
        nsStatusBar.removeStatusItem(this.nsStatusItem);
        Foundation.cfRelease((ID[])new ID[]{ObjcToJava.toID((Object)nsStatusBar)});
        this.trayMenu = null;
    }

    @Override
    public void showContextMenu(Menu menu, MouseEvent event) {
        Optional.ofNullable(this.sharedApplication.keyWindow()).map(NSWindow::contentView).ifPresent(view -> {
            NSMenu nsMenu = MenuConverter.convert(menu);
            NSPoint nsPoint = new NSPoint();
            nsPoint.x = new Foundation.CGFloat(event.getSceneX());
            nsPoint.y = new Foundation.CGFloat(event.getSceneY());
            nsMenu.popUpMenuPositioningItem(null, nsPoint, view);
        });
    }

    @Override
    public void setDocIconMenu(Menu menu) {
        if (this.applicationDelegate == null) {
            NSApplicationDelegate delegate = this.sharedApplication.delegate();
            this.applicationDelegate = new ApplicationDelegateWithMenu(delegate);
            ID mappedObject = JavaToObjc.map((Object)((Object)this.applicationDelegate));
            this.sharedApplication.setDelegate((NSApplicationDelegate)ObjcToJava.map((ID)mappedObject, NSApplicationDelegate.class));
        }
        NSMenu nsMenu = MenuConverter.convert(menu);
        this.applicationDelegate.setMenu(nsMenu);
        this.dockIconMenu = menu;
    }

    @Override
    public boolean systemUsesDarkMode() {
        return "Dark".equals(NSUserDefaults.standardUserDefaults().objectForKey("AppleInterfaceStyle"));
    }

    @Override
    public void setAppearanceMode(AppearanceMode mode) {
        switch (mode) {
            case AUTO: {
                NSAppearance.NSAppearanceName appearanceName = this.systemUsesDarkMode() ? NSAppearance.NSAppearanceName.NSAppearanceNameVibrantDark : NSAppearance.NSAppearanceName.NSAppearanceNameVibrantLight;
                this.sharedApplication.setAppearance(NSAppearance.appearanceNamed((NSAppearance.NSAppearanceName)appearanceName));
                break;
            }
            case DARK: {
                this.sharedApplication.setAppearance(NSAppearance.appearanceNamed((NSAppearance.NSAppearanceName)NSAppearance.NSAppearanceName.NSAppearanceNameVibrantDark));
                break;
            }
            case LIGHT: {
                this.sharedApplication.setAppearance(NSAppearance.appearanceNamed((NSAppearance.NSAppearanceName)NSAppearance.NSAppearanceName.NSAppearanceNameVibrantLight));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

