/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.listener;

import java.util.List;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.stage.Window;

public class FirstWindowShowingEventListener
implements ListChangeListener<Window> {
    private Runnable action;
    private boolean completed = false;

    public FirstWindowShowingEventListener() {
        this.watchWindows((List<? extends Window>)Window.getWindows());
        Window.getWindows().addListener((ListChangeListener)this);
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void onChanged(ListChangeListener.Change<? extends Window> change) {
        while (change.next()) {
            this.watchWindows(change.getAddedSubList());
        }
    }

    private void watchWindows(List<? extends Window> windows) {
        windows.forEach(added -> added.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                Optional.ofNullable(FirstWindowShowingEventListener.this.action).ifPresent(Runnable::run);
                FirstWindowShowingEventListener.this.completed = true;
                added.showingProperty().removeListener((ChangeListener)this);
                Window.getWindows().removeListener((ListChangeListener)FirstWindowShowingEventListener.this);
            }
        }));
    }
}

