/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.labels;

import de.jangassen.labels.LabelName;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;

public class LabelMaker {
    public static final String PROPERTY_FILE_EXTENSION = ".properties";
    public static final String PROPERTY_FILE_PREFIX = "menu_labels_";
    private final Properties properties;
    private final Locale locale;

    public LabelMaker(Locale locale) {
        this.locale = locale;
        this.properties = new Properties();
        this.loadLabelsForLocale(locale);
    }

    private void loadLabelsForLocale(Locale locale) {
        InputStream resource = this.getLabelResource(locale);
        if (resource != null) {
            try {
                this.loadLabels(resource);
            }
            catch (IOException e) {
                System.err.println("Unable to load properties: " + e.getMessage());
            }
        }
    }

    public void loadLabels(InputStream resource) throws IOException {
        this.properties.load(new InputStreamReader(resource, "UTF-8"));
    }

    private InputStream getLabelResource(Locale locale) {
        InputStream resource = LabelMaker.class.getClassLoader().getResourceAsStream(this.getBCP47ResourceName(locale));
        if (resource != null) {
            return resource;
        }
        resource = LabelMaker.class.getClassLoader().getResourceAsStream(this.getISO639ResourceName(locale));
        if (resource != null) {
            return resource;
        }
        return LabelMaker.class.getClassLoader().getResourceAsStream(this.getISO639ResourceName(Locale.ENGLISH));
    }

    private String getISO639ResourceName(Locale locale) {
        return this.getResourceName(locale.getLanguage());
    }

    private String getBCP47ResourceName(Locale locale) {
        return this.getResourceName(locale.toLanguageTag().replace('-', '_'));
    }

    public String getResourceName(String label) {
        return PROPERTY_FILE_PREFIX + label + PROPERTY_FILE_EXTENSION;
    }

    public String getLabel(LabelName menuItemName, Object ... args) {
        String property = this.properties.getProperty(menuItemName.getPropertyKey());
        if (property == null) {
            return this.getPlaceholderValue(menuItemName);
        }
        return String.format(this.locale, property, args);
    }

    private String getPlaceholderValue(LabelName name) {
        return "\u00a7" + name.getPropertyKey() + "\u00a7";
    }
}

