package de.jangassen.jfa.appkit;

import com.sun.jna.Pointer;
import de.jangassen.jfa.ObjcToJava;
import de.jangassen.jfa.annotation.NamedArg;
import de.jangassen.jfa.foundation.ID;

public interface NSDistributedNotificationCenter extends NSObject {
  static NSDistributedNotificationCenter defaultCenter() {
    return ObjcToJava.invokeStatic(NSDistributedNotificationCenter.class, "defaultCenter");
  }

  void addObserver(ID observer, @NamedArg("selector") Pointer aSelector, @NamedArg("name") NSNotificationName aName, @NamedArg("object") NSString anObject);

  void removeObserver(ID observer, @NamedArg("name") NSNotificationName aName, @NamedArg("object") NSString anObject);

  void postNotificationName(NSNotificationName name, @NamedArg("object") NSString object, @NamedArg("userInfo") NSDictionary<?, ?> userInfo, @NamedArg("deliverImmediately") boolean deliverImmediately);

  enum NSNotificationName {
    ABPeoplePickerDisplayedPropertyDidChangeNotification,
    ABPeoplePickerGroupSelectionDidChangeNotification,
    ABPeoplePickerNameSelectionDidChangeNotification,
    ABPeoplePickerValueSelectionDidChangeNotification,
    ACAccountStoreDidChangeNotification,
    ALAssetsLibraryChangedNotification,
    AVAssetChapterMetadataGroupsDidChangeNotification,
    AVAssetContainsFragmentsDidChangeNotification,
    AVAssetDurationDidChangeNotification,
    AVAssetMediaSelectionGroupsDidChangeNotification,
    AVAssetTrackSegmentsDidChangeNotification,
    AVAssetTrackTimeRangeDidChangeNotification,
    AVAssetTrackTrackAssociationsDidChangeNotification,
    AVAssetWasDefragmentedNotification,
    AVAudioEngineConfigurationChangeNotification,
    AVAudioSessionInterruptionNotification,
    AVAudioSessionMediaServicesWereLostNotification,
    AVAudioSessionMediaServicesWereResetNotification,
    AVAudioSessionRouteChangeNotification,
    AVAudioSessionSilenceSecondaryAudioHintNotification,
    AVAudioUnitComponentTagsDidChangeNotification,
    AVCaptureDeviceSubjectAreaDidChangeNotification,
    AVCaptureDeviceWasConnectedNotification,
    AVCaptureDeviceWasDisconnectedNotification,
    AVCaptureInputPortFormatDescriptionDidChangeNotification,
    AVCaptureSessionDidStartRunningNotification,
    AVCaptureSessionDidStopRunningNotification,
    AVCaptureSessionInterruptionEndedNotification,
    AVCaptureSessionRuntimeErrorNotification,
    AVCaptureSessionWasInterruptedNotification,
    AVDisplayManagerModeSwitchEndNotification,
    AVDisplayManagerModeSwitchSettingsChangedNotification,
    AVDisplayManagerModeSwitchStartNotification,
    AVFragmentedMovieContainsMovieFragmentsDidChangeNotification,
    AVFragmentedMovieDurationDidChangeNotification,
    AVFragmentedMovieTrackSegmentsDidChangeNotification,
    AVFragmentedMovieTrackTimeRangeDidChangeNotification,
    AVFragmentedMovieTrackTotalSampleDataLengthDidChangeNotification,
    AVFragmentedMovieWasDefragmentedNotification,
    AVPlayerAvailableHDRModesDidChangeNotification,
    AVPlayerInterstitialEventObserverCurrentEventDidChangeNotification,
    AVPlayerInterstitialEventObserverEventsDidChangeNotification,
    AVPlayerItemDidPlayToEndTimeNotification,
    AVPlayerItemFailedToPlayToEndTimeNotification,
    AVPlayerItemNewAccessLogEntryNotification,
    AVPlayerItemNewErrorLogEntryNotification,
    AVPlayerItemPlaybackStalledNotification,
    AVPlayerItemTimeJumpedNotification,
    AVRouteDetectorMultipleRoutesDetectedDidChangeNotification,
    AVSampleBufferAudioRendererWasFlushedAutomaticallyNotification,
    AVSampleBufferDisplayLayerFailedToDecodeNotification,
    AVSampleBufferDisplayLayerOutputObscuredDueToInsufficientExternalProtectionDidChangeNotification,
    AVSampleBufferDisplayLayerRequiresFlushToResumeDecodingDidChangeNotification,
    CKAccountChangedNotification,
    CLKComplicationServerActiveComplicationsDidChangeNotification,
    CNContactStoreDidChangeNotification,
    CTRadioAccessTechnologyDidChangeNotification,
    CTServiceRadioAccessTechnologyDidChangeNotification,
    CWBSSIDDidChangeNotification,
    CWCountryCodeDidChangeNotification,
    CWLinkDidChangeNotification,
    CWLinkQualityDidChangeNotification,
    CWModeDidChangeNotification,
    CWPowerDidChangeNotification,
    CWSSIDDidChangeNotification,
    CWScanCacheDidUpdateNotification,
    EAAccessoryDidConnectNotification,
    EAAccessoryDidDisconnectNotification,
    EKEventStoreChangedNotification,
    GCControllerDidBecomeCurrentNotification,
    GCControllerDidConnectNotification,
    GCControllerDidDisconnectNotification,
    GCControllerDidStopBeingCurrentNotification,
    GCKeyboardDidConnectNotification,
    GCKeyboardDidDisconnectNotification,
    GCMouseDidBecomeCurrentNotification,
    GCMouseDidConnectNotification,
    GCMouseDidDisconnectNotification,
    GCMouseDidStopBeingCurrentNotification,
    HKUserPreferencesDidChangeNotification,
    HMCharacteristicPropertySupportsEventNotification,
    IKFilterBrowserFilterDoubleClickNotification,
    IKFilterBrowserFilterSelectedNotification,
    IKFilterBrowserWillPreviewFilterNotification,
    IOBluetoothHostControllerPoweredOffNotification,
    IOBluetoothHostControllerPoweredOnNotification,
    IOBluetoothL2CAPChannelPublishedNotification,
    IOBluetoothL2CAPChannelTerminatedNotification,
    MFMessageComposeViewControllerTextMessageAvailabilityDidChangeNotification,
    MKAnnotationCalloutInfoDidChangeNotification,
    MPMediaLibraryDidChangeNotification,
    MPMediaPlaybackIsPreparedToPlayDidChangeNotification,
    MPMovieDurationAvailableNotification,
    MPMovieMediaTypesAvailableNotification,
    MPMovieNaturalSizeAvailableNotification,
    MPMoviePlayerDidEnterFullscreenNotification,
    MPMoviePlayerDidExitFullscreenNotification,
    MPMoviePlayerIsAirPlayVideoActiveDidChangeNotification,
    MPMoviePlayerLoadStateDidChangeNotification,
    MPMoviePlayerNowPlayingMovieDidChangeNotification,
    MPMoviePlayerPlaybackDidFinishNotification,
    MPMoviePlayerPlaybackStateDidChangeNotification,
    MPMoviePlayerReadyForDisplayDidChangeNotification,
    MPMoviePlayerScalingModeDidChangeNotification,
    MPMoviePlayerThumbnailImageRequestDidFinishNotification,
    MPMoviePlayerTimedMetadataUpdatedNotification,
    MPMoviePlayerWillEnterFullscreenNotification,
    MPMoviePlayerWillExitFullscreenNotification,
    MPMovieSourceTypeAvailableNotification,
    MPMusicPlayerControllerNowPlayingItemDidChangeNotification,
    MPMusicPlayerControllerPlaybackStateDidChangeNotification,
    MPMusicPlayerControllerQueueDidChangeNotification,
    MPMusicPlayerControllerVolumeDidChangeNotification,
    MPVolumeViewWirelessRouteActiveDidChangeNotification,
    MPVolumeViewWirelessRoutesAvailableDidChangeNotification,
    NEDNSProxyConfigurationDidChangeNotification,
    NEDNSSettingsConfigurationDidChangeNotification,
    NEFilterConfigurationDidChangeNotification,
    NEVPNConfigurationChangeNotification,
    NEVPNStatusDidChangeNotification,
    NKIssueDownloadCompletedNotification,
    NSAccessibilityAnnouncementRequestedNotification,
    NSAccessibilityApplicationActivatedNotification,
    NSAccessibilityApplicationDeactivatedNotification,
    NSAccessibilityApplicationHiddenNotification,
    NSAccessibilityApplicationShownNotification,
    NSAccessibilityCreatedNotification,
    NSAccessibilityDrawerCreatedNotification,
    NSAccessibilityFocusedUIElementChangedNotification,
    NSAccessibilityFocusedWindowChangedNotification,
    NSAccessibilityHelpTagCreatedNotification,
    NSAccessibilityLayoutChangedNotification,
    NSAccessibilityMainWindowChangedNotification,
    NSAccessibilityMovedNotification,
    NSAccessibilityPostNotification,
    NSAccessibilityResizedNotification,
    NSAccessibilityRowCollapsedNotification,
    NSAccessibilityRowCountChangedNotification,
    NSAccessibilityRowExpandedNotification,
    NSAccessibilitySelectedCellsChangedNotification,
    NSAccessibilitySelectedChildrenChangedNotification,
    NSAccessibilitySelectedChildrenMovedNotification,
    NSAccessibilitySelectedColumnsChangedNotification,
    NSAccessibilitySelectedRowsChangedNotification,
    NSAccessibilitySelectedTextChangedNotification,
    NSAccessibilitySheetCreatedNotification,
    NSAccessibilityTitleChangedNotification,
    NSAccessibilityUIElementDestroyedNotification,
    NSAccessibilityUnitsChangedNotification,
    NSAccessibilityValueChangedNotification,
    NSAccessibilityWindowCreatedNotification,
    NSAccessibilityWindowDeminiaturizedNotification,
    NSAccessibilityWindowMiniaturizedNotification,
    NSAccessibilityWindowMovedNotification,
    NSAccessibilityWindowResizedNotification,
    NSAnimationProgressMarkNotification,
    NSAntialiasThresholdChangedNotification,
    NSAppleEventManagerWillProcessFirstEventNotification,
    NSApplicationDidBecomeActiveNotification,
    NSApplicationDidChangeOcclusionStateNotification,
    NSApplicationDidChangeScreenParametersNotification,
    NSApplicationDidFinishLaunchingNotification,
    NSApplicationDidFinishRestoringWindowsNotification,
    NSApplicationDidHideNotification,
    NSApplicationDidResignActiveNotification,
    NSApplicationDidUnhideNotification,
    NSApplicationDidUpdateNotification,
    NSApplicationWillBecomeActiveNotification,
    NSApplicationWillFinishLaunchingNotification,
    NSApplicationWillHideNotification,
    NSApplicationWillResignActiveNotification,
    NSApplicationWillTerminateNotification,
    NSApplicationWillUnhideNotification,
    NSApplicationWillUpdateNotification,
    NSBrowserColumnConfigurationDidChangeNotification,
    NSBundleResourceRequestLowDiskSpaceNotification,
    NSCalendarDayChangedNotification,
    NSClassDescriptionNeededForClassNotification,
    NSColorListDidChangeNotification,
    NSColorPanelColorDidChangeNotification,
    NSComboBoxSelectionDidChangeNotification,
    NSComboBoxSelectionIsChangingNotification,
    NSComboBoxWillDismissNotification,
    NSComboBoxWillPopUpNotification,
    NSContextHelpModeDidActivateNotification,
    NSContextHelpModeDidDeactivateNotification,
    NSControlTextDidBeginEditingNotification,
    NSControlTextDidChangeNotification,
    NSControlTextDidEndEditingNotification,
    NSControlTintDidChangeNotification,
    NSDidBecomeSingleThreadedNotification,
    NSDrawerDidCloseNotification,
    NSDrawerDidOpenNotification,
    NSDrawerWillCloseNotification,
    NSDrawerWillOpenNotification,
    NSExtensionHostDidBecomeActiveNotification,
    NSExtensionHostDidEnterBackgroundNotification,
    NSExtensionHostWillEnterForegroundNotification,
    NSExtensionHostWillResignActiveNotification,
    NSFileHandleConnectionAcceptedNotification,
    NSFileHandleDataAvailableNotification,
    NSFileHandleReadToEndOfFileCompletionNotification,
    NSFontCollectionDidChangeNotification,
    NSFontSetChangedNotification,
    NSHTTPCookieManagerAcceptPolicyChangedNotification,
    NSHTTPCookieManagerCookiesChangedNotification,
    NSImageRepRegistryDidChangeNotification,
    NSManagedObjectContextDidMergeChangesObjectIDsNotification,
    NSManagedObjectContextDidSaveNotification,
    NSManagedObjectContextDidSaveObjectIDsNotification,
    NSManagedObjectContextObjectsDidChangeNotification,
    NSManagedObjectContextWillSaveNotification,
    NSMenuDidAddItemNotification,
    NSMenuDidBeginTrackingNotification,
    NSMenuDidChangeItemNotification,
    NSMenuDidEndTrackingNotification,
    NSMenuDidRemoveItemNotification,
    NSMenuDidSendActionNotification,
    NSMenuWillSendActionNotification,
    NSMetadataQueryDidFinishGatheringNotification,
    NSMetadataQueryDidStartGatheringNotification,
    NSMetadataQueryDidUpdateNotification,
    NSMetadataQueryGatheringProgressNotification,
    NSOutlineViewColumnDidMoveNotification,
    NSOutlineViewColumnDidResizeNotification,
    NSOutlineViewItemDidCollapseNotification,
    NSOutlineViewItemDidExpandNotification,
    NSOutlineViewItemWillCollapseNotification,
    NSOutlineViewItemWillExpandNotification,
    NSOutlineViewSelectionDidChangeNotification,
    NSOutlineViewSelectionIsChangingNotification,
    NSPersistentStoreCoordinatorStoresDidChangeNotification,
    NSPersistentStoreCoordinatorStoresWillChangeNotification,
    NSPersistentStoreCoordinatorWillRemoveStoreNotification,
    NSPersistentStoreDidImportUbiquitousContentChangesNotification,
    NSPersistentStoreRemoteChangeNotification,
    NSPopUpButtonCellWillPopUpNotification,
    NSPopUpButtonWillPopUpNotification,
    NSPopoverDidCloseNotification,
    NSPopoverDidShowNotification,
    NSPopoverWillCloseNotification,
    NSPopoverWillShowNotification,
    NSPreferencePaneCancelUnselectNotification,
    NSPreferencePaneDoUnselectNotification,
    NSPreferencePaneSwitchToPaneNotification,
    NSPreferencePaneUpdateHelpMenuNotification,
    NSPreferencePrefPaneIsAvailableNotification,
    NSPreferredScrollerStyleDidChangeNotification,
    NSProcessInfoPowerStateDidChangeNotification,
    NSRuleEditorRowsDidChangeNotification,
    NSScreenColorSpaceDidChangeNotification,
    NSScrollViewDidEndLiveMagnifyNotification,
    NSScrollViewDidEndLiveScrollNotification,
    NSScrollViewDidLiveScrollNotification,
    NSScrollViewWillStartLiveMagnifyNotification,
    NSScrollViewWillStartLiveScrollNotification,
    NSSpellCheckerDidChangeAutomaticCapitalizationNotification,
    NSSpellCheckerDidChangeAutomaticDashSubstitutionNotification,
    NSSpellCheckerDidChangeAutomaticPeriodSubstitutionNotification,
    NSSpellCheckerDidChangeAutomaticQuoteSubstitutionNotification,
    NSSpellCheckerDidChangeAutomaticSpellingCorrectionNotification,
    NSSpellCheckerDidChangeAutomaticTextCompletionNotification,
    NSSpellCheckerDidChangeAutomaticTextReplacementNotification,
    NSSplitViewDidResizeSubviewsNotification,
    NSSplitViewWillResizeSubviewsNotification,
    NSSystemClockDidChangeNotification,
    NSSystemColorsDidChangeNotification,
    NSSystemTimeZoneDidChangeNotification,
    NSTableViewColumnDidMoveNotification,
    NSTableViewColumnDidResizeNotification,
    NSTableViewSelectionDidChangeNotification,
    NSTableViewSelectionIsChangingNotification,
    NSTextAlternativesSelectedAlternativeStringNotification,
    NSTextDidBeginEditingNotification,
    NSTextDidChangeNotification,
    NSTextDidEndEditingNotification,
    NSTextInputContextKeyboardSelectionDidChangeNotification,
    NSTextStorageDidProcessEditingNotification,
    NSTextStorageWillProcessEditingNotification,
    NSTextViewDidChangeSelectionNotification,
    NSTextViewDidChangeTypingAttributesNotification,
    NSTextViewWillChangeNotifyingTextViewNotification,
    NSThreadWillExitNotification,
    NSToolbarDidRemoveItemNotification,
    NSToolbarWillAddItemNotification,
    NSURLCredentialStorageChangedNotification,
    NSUbiquityIdentityDidChangeNotification,
    NSUndoManagerCheckpointNotification,
    NSUndoManagerDidCloseUndoGroupNotification,
    NSUndoManagerDidOpenUndoGroupNotification,
    NSUndoManagerDidRedoChangeNotification,
    NSUndoManagerDidUndoChangeNotification,
    NSUndoManagerWillCloseUndoGroupNotification,
    NSUndoManagerWillRedoChangeNotification,
    NSUndoManagerWillUndoChangeNotification,
    NSViewBoundsDidChangeNotification,
    NSViewDidUpdateTrackingAreasNotification,
    NSViewFocusDidChangeNotification,
    NSViewFrameDidChangeNotification,
    NSViewGlobalFrameDidChangeNotification,
    NSWillBecomeMultiThreadedNotification,
    NSWindowDidBecomeKeyNotification,
    NSWindowDidBecomeMainNotification,
    NSWindowDidChangeBackingPropertiesNotification,
    NSWindowDidChangeOcclusionStateNotification,
    NSWindowDidChangeScreenNotification,
    NSWindowDidChangeScreenProfileNotification,
    NSWindowDidDeminiaturizeNotification,
    NSWindowDidEndLiveResizeNotification,
    NSWindowDidEndSheetNotification,
    NSWindowDidEnterFullScreenNotification,
    NSWindowDidEnterVersionBrowserNotification,
    NSWindowDidExitFullScreenNotification,
    NSWindowDidExitVersionBrowserNotification,
    NSWindowDidExposeNotification,
    NSWindowDidMiniaturizeNotification,
    NSWindowDidMoveNotification,
    NSWindowDidResignKeyNotification,
    NSWindowDidResignMainNotification,
    NSWindowDidResizeNotification,
    NSWindowDidUpdateNotification,
    NSWindowWillBeginSheetNotification,
    NSWindowWillCloseNotification,
    NSWindowWillEnterFullScreenNotification,
    NSWindowWillEnterVersionBrowserNotification,
    NSWindowWillExitFullScreenNotification,
    NSWindowWillExitVersionBrowserNotification,
    NSWindowWillMiniaturizeNotification,
    NSWindowWillMoveNotification,
    NSWindowWillStartLiveResizeNotification,
    NSWorkspaceAccessibilityDisplayOptionsDidChangeNotification,
    NSWorkspaceActiveSpaceDidChangeNotification,
    NSWorkspaceDidActivateApplicationNotification,
    NSWorkspaceDidChangeFileLabelsNotification,
    NSWorkspaceDidDeactivateApplicationNotification,
    NSWorkspaceDidHideApplicationNotification,
    NSWorkspaceDidLaunchApplicationNotification,
    NSWorkspaceDidMountNotification,
    NSWorkspaceDidPerformFileOperationNotification,
    NSWorkspaceDidRenameVolumeNotification,
    NSWorkspaceDidTerminateApplicationNotification,
    NSWorkspaceDidUnhideApplicationNotification,
    NSWorkspaceDidUnmountNotification,
    NSWorkspaceDidWakeNotification,
    NSWorkspaceScreensDidSleepNotification,
    NSWorkspaceScreensDidWakeNotification,
    NSWorkspaceSessionDidBecomeActiveNotification,
    NSWorkspaceSessionDidResignActiveNotification,
    NSWorkspaceWillLaunchApplicationNotification,
    NSWorkspaceWillPowerOffNotification,
    NSWorkspaceWillSleepNotification,
    NSWorkspaceWillUnmountNotification,
    PDFDocumentDidBeginFindNotification,
    PDFDocumentDidBeginPageFindNotification,
    PDFDocumentDidBeginPageWriteNotification,
    PDFDocumentDidBeginWriteNotification,
    PDFDocumentDidEndFindNotification,
    PDFDocumentDidEndPageFindNotification,
    PDFDocumentDidEndPageWriteNotification,
    PDFDocumentDidEndWriteNotification,
    PDFDocumentDidFindMatchNotification,
    PDFDocumentDidUnlockNotification,
    PDFThumbnailViewDocumentEditedNotification,
    PDFViewAnnotationHitNotification,
    PDFViewAnnotationWillHitNotification,
    PDFViewChangedHistoryNotification,
    PDFViewCopyPermissionNotification,
    PDFViewDisplayBoxChangedNotification,
    PDFViewDisplayModeChangedNotification,
    PDFViewDocumentChangedNotification,
    PDFViewPageChangedNotification,
    PDFViewPrintPermissionNotification,
    PDFViewScaleChangedNotification,
    PDFViewSelectionChangedNotification,
    PDFViewVisiblePagesChangedNotification,
    PKPassLibraryDidChangeNotification,
    PKPassLibraryRemotePaymentPassesDidChangeNotification,
    QCCompositionPickerPanelDidSelectCompositionNotification,
    QCCompositionPickerViewDidSelectCompositionNotification,
    QCCompositionRepositoryDidUpdateNotification,
    QCViewDidStartRenderingNotification,
    QCViewDidStopRenderingNotification,
    SKCloudServiceCapabilitiesDidChangeNotification,
    SKStorefrontCountryCodeDidChangeNotification,
    SKStorefrontIdentifierDidChangeNotification,
    TVTopShelfItemsDidChangeNotification,
    UIAccessibilityAnnouncementDidFinishNotification,
    UIAccessibilityAssistiveTouchStatusDidChangeNotification,
    UIAccessibilityBoldTextStatusDidChangeNotification,
    UIAccessibilityClosedCaptioningStatusDidChangeNotification,
    UIAccessibilityDarkerSystemColorsStatusDidChangeNotification,
    UIAccessibilityElementFocusedNotification,
    UIAccessibilityGrayscaleStatusDidChangeNotification,
    UIAccessibilityGuidedAccessStatusDidChangeNotification,
    UIAccessibilityHearingDevicePairedEarDidChangeNotification,
    UIAccessibilityInvertColorsStatusDidChangeNotification,
    UIAccessibilityMonoAudioStatusDidChangeNotification,
    UIAccessibilityReduceMotionStatusDidChangeNotification,
    UIAccessibilityReduceTransparencyStatusDidChangeNotification,
    UIAccessibilityShakeToUndoDidChangeNotification,
    UIAccessibilitySpeakScreenStatusDidChangeNotification,
    UIAccessibilitySpeakSelectionStatusDidChangeNotification,
    UIAccessibilitySwitchControlStatusDidChangeNotification,
    UIApplicationBackgroundRefreshStatusDidChangeNotification,
    UIApplicationDidBecomeActiveNotification,
    UIApplicationDidChangeStatusBarFrameNotification,
    UIApplicationDidChangeStatusBarOrientationNotification,
    UIApplicationDidEnterBackgroundNotification,
    UIApplicationDidFinishLaunchingNotification,
    UIApplicationDidReceiveMemoryWarningNotification,
    UIApplicationSignificantTimeChangeNotification,
    UIApplicationUserDidTakeScreenshotNotification,
    UIApplicationWillChangeStatusBarFrameNotification,
    UIApplicationWillChangeStatusBarOrientationNotification,
    UIApplicationWillEnterForegroundNotification,
    UIApplicationWillResignActiveNotification,
    UIApplicationWillTerminateNotification,
    UIContentSizeCategoryDidChangeNotification,
    UIDeviceBatteryLevelDidChangeNotification,
    UIDeviceBatteryStateDidChangeNotification,
    UIDeviceOrientationDidChangeNotification,
    UIDeviceProximityStateDidChangeNotification,
    UIDocumentStateChangedNotification,
    UIKeyboardDidChangeFrameNotification,
    UIKeyboardDidHideNotification,
    UIKeyboardDidShowNotification,
    UIKeyboardWillChangeFrameNotification,
    UIKeyboardWillHideNotification,
    UIKeyboardWillShowNotification,
    UIMenuControllerDidHideMenuNotification,
    UIMenuControllerDidShowMenuNotification,
    UIMenuControllerMenuFrameDidChangeNotification,
    UIMenuControllerWillHideMenuNotification,
    UIMenuControllerWillShowMenuNotification,
    UIPasteboardChangedNotification,
    UIPasteboardRemovedNotification,
    UIScreenBrightnessDidChangeNotification,
    UIScreenDidConnectNotification,
    UIScreenDidDisconnectNotification,
    UIScreenModeDidChangeNotification,
    UITableViewSelectionDidChangeNotification,
    UITextFieldTextDidBeginEditingNotification,
    UITextFieldTextDidChangeNotification,
    UITextFieldTextDidEndEditingNotification,
    UITextInputCurrentInputModeDidChangeNotification,
    UITextViewTextDidBeginEditingNotification,
    UITextViewTextDidChangeNotification,
    UITextViewTextDidEndEditingNotification,
    UIViewControllerShowDetailTargetDidChangeNotification,
    UIWindowDidBecomeHiddenNotification,
    UIWindowDidBecomeKeyNotification,
    UIWindowDidBecomeVisibleNotification,
    UIWindowDidResignKeyNotification,
    WKAccessibilityReduceMotionStatusDidChangeNotification,
    WKAudioFilePlayerItemDidPlayToEndTimeNotification,
    WKAudioFilePlayerItemFailedToPlayToEndTimeNotification,
    WKAudioFilePlayerItemTimeJumpedNotification,
    WebHistoryAllItemsRemovedNotification,
    WebHistoryItemChangedNotification,
    WebHistoryItemsAddedNotification,
    WebHistoryItemsRemovedNotification,
    WebHistoryLoadedNotification,
    WebHistorySavedNotification,
    WebPreferencesChangedNotification,
    WebViewDidBeginEditingNotification,
    WebViewDidChangeNotification,
    WebViewDidChangeSelectionNotification,
    WebViewDidChangeTypingStyleNotification,
    WebViewDidEndEditingNotification,
    WebViewProgressEstimateChangedNotification,
    WebViewProgressFinishedNotification,
    WebViewProgressStartedNotification
  }
}
