/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.jfa;

import com.sun.jna.Callback;
import de.jangassen.jfa.ObjcToJava;
import de.jangassen.jfa.Selector;
import de.jangassen.jfa.annotation.ConformsToProtocols;
import de.jangassen.jfa.annotation.InheritMethodsUpTo;
import de.jangassen.jfa.annotation.Superclass;
import de.jangassen.jfa.annotation.Unmapped;
import de.jangassen.jfa.cleanup.NSCleaner;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import de.jangassen.jfa.util.StreamUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class JavaToObjc {
    private static final ConcurrentHashMap<String, ID> NAME_TO_CLASS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ID, WeakReference<Object>> INSTANCE_TO_JAVA = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ID, List<Callback>> CLASS_TO_CALLBACK = new ConcurrentHashMap();

    private JavaToObjc() {
    }

    public static ID map(Object obj) {
        return JavaToObjc.map(obj, obj.getClass());
    }

    public static ID map(Object obj, Class<?> clazz) {
        ID classId = JavaToObjc.getClassId(clazz);
        ID instanceId = Foundation.invoke(classId, "alloc", new Object[0]);
        INSTANCE_TO_JAVA.put(instanceId, new WeakReference<Object>(obj));
        NSCleaner.register(obj, instanceId);
        return instanceId;
    }

    public static ID getClassId(Class<?> objectClass) {
        return NAME_TO_CLASS.computeIfAbsent(objectClass.getSimpleName(), key -> JavaToObjc.defineClass(objectClass, key));
    }

    private static ID defineClass(Class<?> clazz, String simpleName) {
        if (simpleName == null || "".equals(simpleName)) {
            throw new IllegalArgumentException("Mapping anonymous classes is not supported");
        }
        String superclass = JavaToObjc.getSuperclass(clazz);
        ID classId = Foundation.allocateObjcClassPair(Foundation.getObjcClass(superclass), simpleName);
        JavaToObjc.addProtocols(clazz, classId);
        Foundation.registerObjcClassPair(classId);
        JavaToObjc.addMethods(clazz, classId);
        return classId;
    }

    private static String getSuperclass(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (!currentClass.isAnnotationPresent(Superclass.class)) continue;
            return Objects.requireNonNull(currentClass.getAnnotation(Superclass.class).value());
        }
        return "NSObject";
    }

    private static void addMethods(Class<?> clazz, ID classId) {
        InheritMethodsUpTo inheritMethodsUpTo = clazz.getAnnotation(InheritMethodsUpTo.class);
        Class<?> rootClass = inheritMethodsUpTo != null ? inheritMethodsUpTo.value() : clazz;
        Arrays.stream(clazz.getMethods()).filter(method -> rootClass.isAssignableFrom(method.getDeclaringClass())).filter(method -> !method.isSynthetic() && !Modifier.isStatic(method.getModifiers())).filter(method -> !method.isAnnotationPresent(Unmapped.class)).forEach(method -> JavaToObjc.addMethod(classId, method));
    }

    private static void addProtocols(Class<?> clazz, ID classId) {
        String[] protocols;
        for (String protocol : protocols = Optional.ofNullable(clazz.getAnnotation(ConformsToProtocols.class)).map(ConformsToProtocols::value).orElse(new String[0])) {
            Foundation.addProtocol(classId, Foundation.getProtocol(protocol));
        }
    }

    private static void addMethod(ID classId, Method method) {
        Callback callback = JavaToObjc.getCallback(method);
        CLASS_TO_CALLBACK.computeIfAbsent(classId, key -> new ArrayList()).add(callback);
        Foundation.addMethod(classId, Selector.forMethod(method), callback, JavaToObjc.getTypes(method));
    }

    private static Callback getCallback(final Method method) {
        switch (method.getParameterCount()) {
            case 0: {
                return new Callback(){

                    public ID callback(ID self, ID cmd) throws InvocationTargetException, IllegalAccessException {
                        return JavaToObjc.invoke(self, method, new ID[0]);
                    }
                };
            }
            case 1: {
                return new Callback(){

                    public ID callback(ID self, ID cmd, ID arg) throws InvocationTargetException, IllegalAccessException {
                        return JavaToObjc.invoke(self, method, new ID[]{arg});
                    }
                };
            }
        }
        throw new IllegalArgumentException("Method with " + method.getParameterCount() + " parameters not supported.");
    }

    private static ID invoke(ID self, Method method, ID[] args) throws IllegalAccessException, InvocationTargetException {
        Object obj;
        WeakReference<Object> javaObject = INSTANCE_TO_JAVA.get((Object)self);
        if (javaObject != null && (obj = javaObject.get()) != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] objects = StreamUtils.zipWithIndex(parameterTypes).map(t -> ObjcToJava.map(args[t.getIndex()], (Class)t.getValue())).toArray();
            Object invoke = method.invoke(obj, objects);
            return ObjcToJava.toID(invoke);
        }
        return ID.NIL;
    }

    private static String getTypes(Method method) {
        return JavaToObjc.toType(method.getReturnType()) + "@:@" + Arrays.stream(method.getParameterTypes()).map(JavaToObjc::toType).map(t -> ":" + t).collect(Collectors.joining());
    }

    private static String toType(Class<?> clazz) {
        if (clazz == Void.class || clazz == Void.TYPE) {
            return "v";
        }
        if (Integer.TYPE == clazz) {
            return "i";
        }
        if (Long.TYPE == clazz) {
            return "l";
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return "@";
        }
        return "?";
    }
}

