/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.jfa;

import com.sun.jna.Pointer;
import de.jangassen.jfa.Selector;
import de.jangassen.jfa.appkit.NSInvocation;
import de.jangassen.jfa.foundation.ID;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class FoundationProxyHandler {
    private final Map<Pointer, Function<NSInvocation, Boolean>> beforeMethodHooks = new HashMap<Pointer, Function<NSInvocation, Boolean>>();
    private final Map<Pointer, Consumer<NSInvocation>> afterMethodHooks = new HashMap<Pointer, Consumer<NSInvocation>>();

    public void addBeforeMethodHook(Method method, Function<NSInvocation, Boolean> handler) {
        this.beforeMethodHooks.put(Selector.forMethod(method), handler);
    }

    public void addAfterMethodHook(Method method, Consumer<NSInvocation> handler) {
        this.afterMethodHooks.put(Selector.forMethod(method), handler);
    }

    public boolean beforeTarget(NSInvocation invocation) {
        Function<NSInvocation, Boolean> nsInvocationBooleanFunction = this.beforeMethodHooks.get(this.getPointer(invocation));
        if (nsInvocationBooleanFunction != null) {
            return nsInvocationBooleanFunction.apply(invocation);
        }
        return true;
    }

    public void afterTarget(NSInvocation invocation) {
        Consumer<NSInvocation> nsInvocationBooleanFunction = this.afterMethodHooks.get(this.getPointer(invocation));
        if (nsInvocationBooleanFunction != null) {
            nsInvocationBooleanFunction.accept(invocation);
        }
    }

    private Pointer getPointer(NSInvocation invocation) {
        ID selector = invocation.selector();
        return new Pointer(selector.longValue());
    }
}

