/*
 * Decompiled with CFR 0.152.
 */
package de.jakobjarosch.rethinkdb.orm.model.geo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Joiner;
import com.rethinkdb.gen.exc.ReqlCompileError;
import com.rethinkdb.gen.proto.TermType;
import com.rethinkdb.model.Arguments;
import de.jakobjarosch.rethinkdb.orm.model.geo.GeoFactory;
import de.jakobjarosch.rethinkdb.orm.model.geo.ReqlGeo;
import de.jakobjarosch.rethinkdb.orm.model.geo.ReqlPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReqlPolygon
extends ReqlGeo {
    private final List<ReqlPoint> points;

    @JsonCreator
    ReqlPolygon(Map<String, Object> data) {
        this(GeoFactory.parsePolygon(data));
    }

    public ReqlPolygon(ReqlPoint ... points) {
        this(Arrays.asList(points));
    }

    public ReqlPolygon(List<ReqlPoint> points) {
        super(TermType.POLYGON, null, null);
        if (points.size() < 3) {
            throw new ReqlCompileError("Polygon must contain at least 3 points");
        }
        points.forEach(arg_0 -> ((Arguments)this.args).coerceAndAdd(arg_0));
        this.points = new ArrayList<ReqlPoint>(points);
    }

    public List<ReqlPoint> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public String toString() {
        return "[ " + Joiner.on((String)", ").join(this.points) + " ]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReqlPolygon that = (ReqlPolygon)((Object)o);
        return Objects.equals(this.points, that.points);
    }

    public int hashCode() {
        return Objects.hash(this.points);
    }
}

