/*
 * Decompiled with CFR 0.152.
 */
package de.jakobjarosch.rethinkdb.orm.model.geo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.rethinkdb.gen.proto.TermType;
import de.jakobjarosch.rethinkdb.orm.model.geo.GeoFactory;
import de.jakobjarosch.rethinkdb.orm.model.geo.ReqlGeo;
import java.util.Map;
import java.util.Objects;

public class ReqlPoint
extends ReqlGeo {
    private final double longitude;
    private final double latitude;

    @JsonCreator
    ReqlPoint(Map<String, Object> data) {
        this(GeoFactory.parseLongitude(data), GeoFactory.parseLatitude(data));
    }

    public ReqlPoint(double longitude, double latitude) {
        super(TermType.POINT, null, null);
        this.args.coerceAndAdd((Object)longitude);
        this.args.coerceAndAdd((Object)latitude);
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public String toString() {
        return "{ longitude: " + this.longitude + ", latitude: " + this.latitude + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReqlPoint reQLPoint = (ReqlPoint)((Object)o);
        return Double.compare(reQLPoint.latitude, this.latitude) == 0 && Double.compare(reQLPoint.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }
}

