/*
 * Decompiled with CFR 0.152.
 */
package de.jakobjarosch.rethinkdb.orm.model.geo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Joiner;
import com.rethinkdb.gen.exc.ReqlCompileError;
import com.rethinkdb.gen.proto.TermType;
import com.rethinkdb.model.Arguments;
import de.jakobjarosch.rethinkdb.orm.model.geo.GeoFactory;
import de.jakobjarosch.rethinkdb.orm.model.geo.ReqlGeo;
import de.jakobjarosch.rethinkdb.orm.model.geo.ReqlPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReqlLine
extends ReqlGeo {
    private final List<ReqlPoint> points;

    @JsonCreator
    ReqlLine(Map<String, Object> data) {
        this(GeoFactory.parseLine(data));
    }

    public ReqlLine(ReqlPoint ... points) {
        this(Arrays.asList(points));
    }

    public ReqlLine(List<ReqlPoint> points) {
        super(TermType.LINE, null, null);
        if (points.size() < 2) {
            throw new ReqlCompileError("Line must contain at least 2 points");
        }
        points.forEach(arg_0 -> ((Arguments)this.args).coerceAndAdd(arg_0));
        this.points = new ArrayList<ReqlPoint>(points);
    }

    public List<ReqlPoint> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public String toString() {
        return "[ " + Joiner.on((String)", ").join(this.points) + " ]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReqlLine reQLLine = (ReqlLine)((Object)o);
        return Objects.equals(this.points, reQLLine.points);
    }

    public int hashCode() {
        return Objects.hash(this.points);
    }
}

