/*
 * Decompiled with CFR 0.152.
 */
package de.jakobjarosch.rethinkdb.orm.model.geo;

import de.jakobjarosch.rethinkdb.orm.model.geo.ReqlPoint;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class GeoFactory {
    GeoFactory() {
    }

    static List<ReqlPoint> parsePolygon(Map<String, Object> data) {
        List points = (List)data.get("coordinates");
        return ((List)points.get(0)).stream().map(GeoFactory::parseCoordinatePair).collect(Collectors.toList());
    }

    static List<ReqlPoint> parseLine(Map<String, Object> data) {
        List points = (List)data.get("coordinates");
        return points.stream().map(GeoFactory::parseCoordinatePair).collect(Collectors.toList());
    }

    static double parseLongitude(Map<String, Object> data) {
        Object longitude = ((List)data.get("coordinates")).get(0);
        return GeoFactory.convertCoordinate(longitude);
    }

    static double parseLatitude(Map<String, Object> data) {
        Object latitude = ((List)data.get("coordinates")).get(1);
        return GeoFactory.convertCoordinate(latitude);
    }

    private static ReqlPoint parseCoordinatePair(List<?> data) {
        return new ReqlPoint(GeoFactory.convertCoordinate(data.get(0)), GeoFactory.convertCoordinate(data.get(1)));
    }

    private static double convertCoordinate(Object longitude) {
        if (longitude instanceof Long) {
            return ((Long)longitude).longValue();
        }
        return (Double)longitude;
    }
}

