/*
 * Decompiled with CFR 0.152.
 */
package de.jakobjarosch.rethinkdb.orm.dao;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.rethinkdb.RethinkDB;
import com.rethinkdb.gen.ast.GetField;
import com.rethinkdb.gen.ast.IndexCreate;
import com.rethinkdb.gen.ast.ReqlExpr;
import com.rethinkdb.gen.ast.Table;
import com.rethinkdb.gen.exc.ReqlClientError;
import com.rethinkdb.gen.exc.ReqlInternalError;
import com.rethinkdb.model.OptArgs;
import com.rethinkdb.net.Connection;
import com.rethinkdb.net.Cursor;
import de.jakobjarosch.rethinkdb.orm.model.ChangeFeedElement;
import de.jakobjarosch.rethinkdb.orm.model.IndexModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Provider;
import rx.Observable;

public class GenericDAO<T, PK> {
    private static final RethinkDB R = RethinkDB.r;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Provider<Connection> connectionProvider;
    private final Class<T> clazz;
    private final String tableName;
    private final String primaryKey;
    private final Set<IndexModel> indices = new HashSet<IndexModel>();

    public GenericDAO(Provider<Connection> connection, Class<T> clazz, String tableName, String primaryKey) {
        this.connectionProvider = connection;
        this.clazz = clazz;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
    }

    protected void addIndex(boolean geo, String fields) {
        this.indices.add(new IndexModel(geo, fields.split(",")));
    }

    public void initTable() {
        try (Connection connection = (Connection)this.connectionProvider.get();){
            if (!this.hasTable(connection, this.tableName)) {
                R.tableCreate((Object)this.tableName).optArg("primary_key", (Object)this.primaryKey).run(connection);
            }
            for (IndexModel index : this.indices) {
                String indexName = Joiner.on((String)"_").join((Object[])index.getFields());
                if (this.hasIndex(connection, indexName)) continue;
                IndexCreate indexCreate = R.table((Object)this.tableName).indexCreate((Object)indexName, row -> this.indexFieldsToReQL(row, index.getFields()));
                if (index.isGeo()) {
                    indexCreate = indexCreate.optArg("geo", (Object)true);
                }
                indexCreate.run(connection);
            }
        }
    }

    public void create(T model) {
        try (Connection connection = (Connection)this.connectionProvider.get();){
            Map result = (Map)R.table((Object)this.tableName).insert(model).run(connection);
            if ((Long)result.get("errors") > 0L) {
                throw new ReqlClientError("Failed to create model. %s", new Object[]{((String)result.get("first_error")).split("\n")[0]});
            }
        }
    }

    public List<T> read() {
        return this.read(t -> t);
    }

    public Optional<T> read(PK id) {
        try (Connection connection = (Connection)this.connectionProvider.get();){
            Map map = (Map)R.table((Object)this.tableName).get(id).run(connection);
            Optional<Object> optional = Optional.ofNullable(MAPPER.convertValue((Object)map, this.clazz));
            return optional;
        }
    }

    public List<T> read(Function<Table, ReqlExpr> filter) {
        Throwable throwable = null;
        try (Connection connection = (Connection)this.connectionProvider.get();){
            Table table = R.table((Object)this.tableName);
            Object result = filter.apply(table).run(connection);
            if (result instanceof List) {
                List list = ((List)result).stream().map(map -> MAPPER.convertValue(map, this.clazz)).collect(Collectors.toList());
                return list;
            }
            if (result instanceof Map) {
                ArrayList arrayList = Lists.newArrayList((Object[])new Object[]{MAPPER.convertValue(result, this.clazz)});
                return arrayList;
            }
            try {
                throw new ReqlInternalError("Unknown return type for query: " + result.getClass());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void update(T model) {
        try (Connection connection = (Connection)this.connectionProvider.get();){
            Map result = (Map)R.table((Object)this.tableName).update(model).run(connection);
            if ((Long)result.get("errors") > 0L) {
                throw new ReqlClientError("Failed to update model. %s", new Object[]{((String)result.get("first_error")).split("\n")[0]});
            }
        }
    }

    public void updateNonAtomic(T model) {
        try (Connection connection = (Connection)this.connectionProvider.get();){
            R.table((Object)this.tableName).update(model).run(connection, OptArgs.of((String)"non_atomic", (Object)true));
        }
    }

    public void delete(PK id) {
        try (Connection connection = (Connection)this.connectionProvider.get();){
            R.table((Object)this.tableName).get(id).delete().run(connection);
        }
    }

    public Observable<ChangeFeedElement<T>> changes() {
        return this.changes(Optional.empty());
    }

    public Observable<ChangeFeedElement<T>> changes(Function<Table, ReqlExpr> filter) {
        return this.changes(Optional.of(filter));
    }

    private Observable<ChangeFeedElement<T>> changes(Optional<Function<Table, ReqlExpr>> filter) {
        return Observable.create(subscriber -> {
            try (Cursor cursor = null;
                 Connection connection = (Connection)this.connectionProvider.get();){
                Table table = R.table((Object)this.tableName);
                cursor = (Cursor)filter.orElse(t -> t).apply(table).changes().run(connection);
                while (!subscriber.isUnsubscribed()) {
                    Map map = (Map)cursor.next();
                    ChangeFeedElement<T> change = this.mapChangeFeedElement(map);
                    subscriber.onNext(change);
                }
            }
        });
    }

    private boolean hasTable(Connection connection, String table) {
        List tables = (List)R.tableList().run(connection);
        return tables.contains(table);
    }

    private boolean hasIndex(Connection connection, String indexName) {
        List indices = (List)R.table((Object)this.tableName).indexList().run(connection);
        return indices.contains(indexName);
    }

    private List indexFieldsToReQL(ReqlExpr row, String[] fields) {
        GetField[] reQLFields = Arrays.stream(fields).map(f -> row.g(f)).collect(Collectors.toList()).toArray(new GetField[0]);
        return R.array((Object)reQLFields, new Object[0]);
    }

    private ChangeFeedElement<T> mapChangeFeedElement(Map<?, Map<?, ?>> map) {
        Map<?, ?> oldVal = map.get("old_val");
        Map<?, ?> newVal = map.get("new_val");
        Object oldValObj = oldVal != null ? MAPPER.convertValue(oldVal, this.clazz) : null;
        Object newValObj = newVal != null ? MAPPER.convertValue(newVal, this.clazz) : null;
        return new ChangeFeedElement<Object>(oldValObj, newValObj);
    }

    static {
        MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

