/*
 * Decompiled with CFR 0.152.
 */
package de.jakobjarosch.rethinkdb.orm;

import com.google.auto.service.AutoService;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.rethinkdb.net.Connection;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import de.jakobjarosch.rethinkdb.orm.annotation.PrimaryKey;
import de.jakobjarosch.rethinkdb.orm.annotation.RethinkDBModel;
import de.jakobjarosch.rethinkdb.orm.dao.GenericDAO;
import de.jakobjarosch.rethinkdb.orm.model.IndexModel;
import de.jakobjarosch.rethinkdb.orm.model.PrimaryKeyModel;
import de.jakobjarosch.rethinkdb.pool.PersistentConnection;
import de.jakobjarosch.rethinkdb.pool.RethinkDBPool;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Provider;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@AutoService(value=Processor.class)
public class RethinkDBDAOProcessor
extends AbstractProcessor {
    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Sets.newHashSet((Object[])new String[]{RethinkDBModel.class.getCanonicalName()});
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.process(roundEnv);
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Something went wrong: " + e);
        }
        return true;
    }

    private void process(RoundEnvironment roundEnv) throws Exception {
        for (Element element : roundEnv.getElementsAnnotatedWith(RethinkDBModel.class)) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            RethinkDBModel modelAnnotation = typeElement.getAnnotation(RethinkDBModel.class);
            PackageElement packageElement = (PackageElement)typeElement.getEnclosingElement();
            String packageName = packageElement.getQualifiedName().toString();
            String daoClassName = typeElement.getSimpleName() + "DAO";
            String daoQualifiedName = packageName.isEmpty() ? daoClassName : packageName + "." + daoClassName;
            PrimaryKeyModel primaryKey = this.scanPrimaryKey(typeElement);
            Set<IndexModel> indices = this.scanIndices(modelAnnotation);
            JavaFileObject fileObject = this.processingEnv.getFiler().createSourceFile(daoQualifiedName, new Element[0]);
            Writer w = fileObject.openWriter();
            Throwable throwable = null;
            try {
                ClassName modelType = ClassName.get((TypeElement)typeElement);
                ClassName primaryKeyType = ClassName.get((String)primaryKey.getPackageName(), (String)primaryKey.getClassName(), (String[])new String[0]);
                ParameterizedTypeName connectionProviderType = ParameterizedTypeName.get((ClassName)ClassName.get(Provider.class), (TypeName[])new TypeName[]{ClassName.get(Connection.class)});
                ParameterizedTypeName genericDAO = ParameterizedTypeName.get((ClassName)ClassName.get(GenericDAO.class), (TypeName[])new TypeName[]{modelType, primaryKeyType});
                TypeSpec type = TypeSpec.classBuilder((String)daoClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)genericDAO).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(RethinkDBPool.class, "pool", new Modifier[0]).addStatement("this(() -> pool.getConnection())", new Object[0]).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Connection.class, "connection", new Modifier[0]).addStatement("this(() -> new $T(connection))", new Object[]{PersistentConnection.class}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)connectionProviderType, "connectionProvider", new Modifier[0]).addStatement("super(connectionProvider, $T.class, $S, $S)", new Object[]{modelType, modelAnnotation.tableName(), primaryKey.getVariableName()}).addCode(this.createIndiceCodeBlock(indices)).build()).build();
                JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)type).build().writeTo((Appendable)w);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (w == null) continue;
                if (throwable != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                w.close();
            }
        }
    }

    private CodeBlock createIndiceCodeBlock(Set<IndexModel> indices) {
        CodeBlock.Builder builder = CodeBlock.builder();
        for (IndexModel index : indices) {
            builder.addStatement("addIndex(" + index.isGeo() + ", $S)", new Object[]{Joiner.on((String)",").join((Object[])index.getFields())});
        }
        return builder.build();
    }

    private PrimaryKeyModel scanPrimaryKey(TypeElement element) {
        List<VariableElement> variables = ElementFilter.fieldsIn(element.getEnclosedElements());
        Set primaryKeys = variables.stream().filter(v -> v.getAnnotation(PrimaryKey.class) != null).collect(Collectors.toSet());
        if (primaryKeys.size() > 1) {
            this.log(Diagnostic.Kind.ERROR, "Only one @PrimaryKey allowed.", new Object[0]);
            throw new IllegalArgumentException();
        }
        return primaryKeys.stream().findFirst().map(v -> new PrimaryKeyModel(this.getTypeElement(v.asType()), v.getSimpleName().toString())).orElse(new PrimaryKeyModel("java.util", "String", "id"));
    }

    private Set<IndexModel> scanIndices(RethinkDBModel element) {
        return Arrays.stream(element.indices()).map(i -> new IndexModel(i.geo(), i.fields())).collect(Collectors.toSet());
    }

    private TypeElement getTypeElement(TypeMirror type) {
        return (TypeElement)this.processingEnv.getTypeUtils().asElement(type);
    }

    private void log(Diagnostic.Kind level, String message, Object ... arguments) {
        this.processingEnv.getMessager().printMessage(level, String.format(message, arguments));
    }
}

