/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.utils;

public class Indentation {
    private final boolean enabled;
    private int currentIndentation = 0;

    public String getIndent() {
        return this.enabled ? Indentation.repeat("  ", this.currentIndentation) : "";
    }

    public String getDelimiter() {
        return this.enabled ? System.lineSeparator() : " ";
    }

    public Indentation indent() {
        return new Indentation(this.enabled, this.currentIndentation + 1);
    }

    public Indentation deIndent() {
        return new Indentation(this.enabled, this.currentIndentation - 1);
    }

    public static Indentation enabled() {
        return new Indentation(true);
    }

    public static Indentation disabled() {
        return new Indentation(false);
    }

    public static Indentation indent(boolean indent) {
        return new Indentation(indent);
    }

    private static String repeat(String input, int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(input);
        }
        return builder.toString();
    }

    private Indentation(boolean enabled, int currentIndentation) {
        this.enabled = enabled;
        this.currentIndentation = currentIndentation;
    }

    private Indentation(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return "Indentation(enabled=" + this.isEnabled() + ", currentIndentation=" + this.currentIndentation + ")";
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

