/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.schema;

import de.jaggl.sqlbuilder.core.columns.Column;
import de.jaggl.sqlbuilder.core.columns.datetime.DateColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.datetime.DateTimeColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.number.doubletype.DecimalColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.number.doubletype.DoubleColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.number.doubletype.FloatColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.number.integer.BigIntColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.number.integer.IntColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.number.integer.MediumIntColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.number.integer.SmallIntColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.number.integer.TinyIntColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.string.CharColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.string.TextColumnBuilder;
import de.jaggl.sqlbuilder.core.columns.string.VarCharColumnBuilder;
import de.jaggl.sqlbuilder.core.conditions.Condition;
import de.jaggl.sqlbuilder.core.domain.BuildingContext;
import de.jaggl.sqlbuilder.core.domain.JoinableTable;
import de.jaggl.sqlbuilder.core.domain.Queryable;
import de.jaggl.sqlbuilder.core.schema.Schema;
import de.jaggl.sqlbuilder.core.utils.BuilderUtils;
import de.jaggl.sqlbuilder.core.utils.Indentation;
import java.util.ArrayList;
import java.util.List;

public class Table
implements Queryable {
    private Schema schema;
    private final String name;
    private String alias;
    private List<Column> columns;

    Table(Schema schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    Table(Schema schema, String name, String alias) {
        this.schema = schema;
        this.name = name;
        this.alias = alias;
    }

    @Override
    public String getValue(BuildingContext context, Indentation indentation) {
        return this.getFullName(context);
    }

    public String getFullName(BuildingContext context) {
        return (String)(this.getSchema() != null ? BuilderUtils.columnApostrophe(this.getSchema().getName(), context) + "." : "") + BuilderUtils.columnApostrophe(this.getName(), context);
    }

    public String getFullNameOrAlias(BuildingContext context) {
        return this.alias != null ? BuilderUtils.columnApostrophe(this.alias, context) : this.getFullName(context);
    }

    public Table as(String alias) {
        return new Table(this.schema, this.name, alias);
    }

    public JoinableTable on(Condition condition) {
        return new JoinableTable(null, this, condition);
    }

    public BigIntColumnBuilder bigIntColumn(String columnName) {
        return new BigIntColumnBuilder(this, columnName);
    }

    public CharColumnBuilder charColumn(String columnName) {
        return new CharColumnBuilder(this, columnName);
    }

    public DecimalColumnBuilder decimalColumn(String columnName) {
        return new DecimalColumnBuilder(this, columnName);
    }

    public DoubleColumnBuilder doubleColumn(String columnName) {
        return new DoubleColumnBuilder(this, columnName);
    }

    public FloatColumnBuilder floatColumn(String columnName) {
        return new FloatColumnBuilder(this, columnName);
    }

    public IntColumnBuilder intColumn(String columnName) {
        return new IntColumnBuilder(this, columnName);
    }

    public MediumIntColumnBuilder mediumIntColumn(String columnName) {
        return new MediumIntColumnBuilder(this, columnName);
    }

    public SmallIntColumnBuilder smallIntColumn(String columnName) {
        return new SmallIntColumnBuilder(this, columnName);
    }

    public TextColumnBuilder textColumn(String columnName) {
        return new TextColumnBuilder(this, columnName);
    }

    public TinyIntColumnBuilder tinyIntColumn(String columnName) {
        return new TinyIntColumnBuilder(this, columnName);
    }

    public VarCharColumnBuilder varCharColumn(String columnName) {
        return new VarCharColumnBuilder(this, columnName);
    }

    public DateColumnBuilder dateColumn(String columnName) {
        return new DateColumnBuilder(this, columnName);
    }

    public DateTimeColumnBuilder dateTimeColumn(String columnName) {
        return new DateTimeColumnBuilder(this, columnName);
    }

    <T extends Column> T addColumn(T column) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        this.columns.add(column);
        return column;
    }

    public static Table create(String name) {
        return new Table(name);
    }

    Table(String name) {
        this.name = name;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public String toString() {
        return "Table(schema=" + this.getSchema() + ", name=" + this.getName() + ", alias=" + this.getAlias() + ")";
    }
}

