/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.queries;

import de.jaggl.sqlbuilder.core.columns.Column;
import de.jaggl.sqlbuilder.core.columns.datetime.DateColumn;
import de.jaggl.sqlbuilder.core.columns.datetime.DateTimeColumn;
import de.jaggl.sqlbuilder.core.columns.number.NumberColumn;
import de.jaggl.sqlbuilder.core.columns.string.StringColumn;
import de.jaggl.sqlbuilder.core.conditions.CombinedCondition;
import de.jaggl.sqlbuilder.core.conditions.Condition;
import de.jaggl.sqlbuilder.core.dialect.Dialect;
import de.jaggl.sqlbuilder.core.domain.ConditionType;
import de.jaggl.sqlbuilder.core.domain.PlainValuable;
import de.jaggl.sqlbuilder.core.domain.Valuable;
import de.jaggl.sqlbuilder.core.domain.ValuableColumn;
import de.jaggl.sqlbuilder.core.domain.ValuableFunction;
import de.jaggl.sqlbuilder.core.functions.Function;
import de.jaggl.sqlbuilder.core.queries.UpdatebleQuery;
import de.jaggl.sqlbuilder.core.schema.Table;
import de.jaggl.sqlbuilder.core.utils.Indentation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class Update
implements UpdatebleQuery {
    private final Table table;
    private Map<Column, Valuable> values = new LinkedHashMap<Column, Valuable>();
    private Condition where;
    private ConditionType whereConditionType;

    Update(Update update) {
        this.table = update.table;
        this.values = new LinkedHashMap<Column, Valuable>(update.values);
        this.where = CombinedCondition.getCopy(update.where);
        this.whereConditionType = update.whereConditionType;
    }

    public Update set(StringColumn<?> column, CharSequence value) {
        return this.set(column, new PlainValuable(value));
    }

    public Update set(NumberColumn<?, ?> column, Number value) {
        return this.set(column, new PlainValuable(value));
    }

    public Update set(NumberColumn<?, ?> column, long value) {
        return this.set(column, new PlainValuable(value));
    }

    public Update set(NumberColumn<?, ?> column, double value) {
        return this.set(column, new PlainValuable(value));
    }

    public Update set(Column column, Function function) {
        return this.set(column, new ValuableFunction(function));
    }

    public Update set(Column column, Column otherColumn) {
        return this.set(column, new ValuableColumn(otherColumn));
    }

    public Update set(DateColumn column, LocalDate value) {
        return this.set((Column)column, new PlainValuable(value));
    }

    public Update set(DateTimeColumn column, LocalDateTime value) {
        return this.set((Column)column, new PlainValuable(value));
    }

    public Update set(Column column, Valuable valuable) {
        this.values.put(column, valuable);
        return this;
    }

    public Update where(Condition condition) {
        this.where = condition;
        this.whereConditionType = ConditionType.WHERE;
        return this;
    }

    public Update whereNot(Condition condition) {
        this.where = condition;
        this.whereConditionType = ConditionType.WHERE_NOT;
        return this;
    }

    @Override
    public String build(Dialect dialect, Indentation indentation) {
        return dialect.build(this, indentation);
    }

    public static void clearWheres(Update update) {
        update.where = null;
    }

    public static Update copy(Update update) {
        return new Update(update);
    }

    Update(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public Map<Column, Valuable> getValues() {
        return this.values;
    }

    public Condition getWhere() {
        return this.where;
    }

    public ConditionType getWhereConditionType() {
        return this.whereConditionType;
    }

    public String toString() {
        return "Update(table=" + this.getTable() + ", values=" + this.getValues() + ", where=" + this.getWhere() + ", whereConditionType=" + this.getWhereConditionType() + ")";
    }
}

