/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.queries;

import de.jaggl.sqlbuilder.core.columns.Column;
import de.jaggl.sqlbuilder.core.conditions.CombinedCondition;
import de.jaggl.sqlbuilder.core.conditions.Condition;
import de.jaggl.sqlbuilder.core.dialect.Dialect;
import de.jaggl.sqlbuilder.core.domain.ConditionType;
import de.jaggl.sqlbuilder.core.domain.Groupable;
import de.jaggl.sqlbuilder.core.domain.JoinType;
import de.jaggl.sqlbuilder.core.domain.Joinable;
import de.jaggl.sqlbuilder.core.domain.JoinableTable;
import de.jaggl.sqlbuilder.core.domain.Limit;
import de.jaggl.sqlbuilder.core.domain.OrderBy;
import de.jaggl.sqlbuilder.core.domain.OrderDirection;
import de.jaggl.sqlbuilder.core.domain.PlainGroupable;
import de.jaggl.sqlbuilder.core.domain.Queryable;
import de.jaggl.sqlbuilder.core.domain.QueryableSelect;
import de.jaggl.sqlbuilder.core.domain.Selectable;
import de.jaggl.sqlbuilder.core.queries.QueryableQuery;
import de.jaggl.sqlbuilder.core.utils.Indentation;
import java.util.ArrayList;
import java.util.List;

public class Select
implements QueryableQuery {
    private boolean distinct;
    private List<Selectable> selectables;
    private Queryable from;
    private List<Joinable> joins;
    private Condition where;
    private ConditionType whereConditionType;
    private List<Groupable> groupBys;
    private Condition having;
    private ConditionType havingConditionType;
    private List<OrderBy> orderBys;
    private Limit limitation;

    Select(Selectable ... selectables) {
        for (Selectable selectable : selectables) {
            this.select(selectable);
        }
    }

    Select(Select select) {
        this.distinct = select.distinct;
        this.selectables = select.selectables != null ? new ArrayList<Selectable>(select.selectables) : null;
        this.from = select.from;
        this.joins = select.joins != null ? new ArrayList<Joinable>(select.joins) : null;
        this.where = CombinedCondition.getCopy(select.where);
        this.whereConditionType = select.whereConditionType;
        this.groupBys = select.groupBys != null ? new ArrayList<Groupable>(select.groupBys) : null;
        this.having = CombinedCondition.getCopy(select.having);
        this.havingConditionType = select.havingConditionType;
        this.orderBys = select.orderBys != null ? new ArrayList<OrderBy>(select.orderBys) : null;
        this.limitation = select.limitation;
    }

    public Select distinct() {
        return this.distinct(true);
    }

    public Select distinct(boolean doDistinct) {
        this.distinct = doDistinct;
        return this;
    }

    public Select select(Selectable ... furtherSelectables) {
        for (Selectable furtherSelectable : furtherSelectables) {
            this.select(furtherSelectable);
        }
        return this;
    }

    private Select select(Selectable selectable) {
        if (this.selectables == null) {
            this.selectables = new ArrayList<Selectable>();
        }
        this.selectables.add(selectable);
        return this;
    }

    public Select from(Queryable table) {
        this.from = table;
        return this;
    }

    public QueryableSelect as(String alias) {
        return new QueryableSelect(this, alias);
    }

    public Select join(JoinableTable table) {
        return this.addJoin(new JoinableTable(null, table.getTable(), table.getCondition()));
    }

    public Select leftJoin(JoinableTable table) {
        return this.addJoin(new JoinableTable(JoinType.LEFT, table.getTable(), table.getCondition()));
    }

    public Select rightJoin(JoinableTable table) {
        return this.addJoin(new JoinableTable(JoinType.RIGHT, table.getTable(), table.getCondition()));
    }

    public Select innerJoin(JoinableTable table) {
        return this.addJoin(new JoinableTable(JoinType.INNER, table.getTable(), table.getCondition()));
    }

    public Select leftOuterJoin(JoinableTable table) {
        return this.addJoin(new JoinableTable(JoinType.LEFT_OUTER, table.getTable(), table.getCondition()));
    }

    public Select rightOuterJoin(JoinableTable table) {
        return this.addJoin(new JoinableTable(JoinType.RIGHT_OUTER, table.getTable(), table.getCondition()));
    }

    public Select fullOuterJoin(JoinableTable table) {
        return this.addJoin(new JoinableTable(JoinType.FULL_OUTER, table.getTable(), table.getCondition()));
    }

    public Select where(Condition condition) {
        this.where = condition;
        this.whereConditionType = ConditionType.WHERE;
        return this;
    }

    public Select whereNot(Condition condition) {
        this.where = condition;
        this.whereConditionType = ConditionType.WHERE_NOT;
        return this;
    }

    private Select addJoin(Joinable join) {
        if (this.joins == null) {
            this.joins = new ArrayList<Joinable>();
        }
        this.joins.add(join);
        return this;
    }

    public Select groupBy(Column ... columns) {
        for (Column column : columns) {
            this.addGroupBy(column);
        }
        return this;
    }

    public Select groupBy(String ... plainGroupBys) {
        for (String plainGroupBy : plainGroupBys) {
            this.addGroupBy(new PlainGroupable(plainGroupBy));
        }
        return this;
    }

    private Select addGroupBy(Groupable groupable) {
        if (this.groupBys == null) {
            this.groupBys = new ArrayList<Groupable>();
        }
        this.groupBys.add(groupable);
        return this;
    }

    public Select having(Condition condition) {
        this.having = condition;
        this.havingConditionType = ConditionType.WHERE;
        return this;
    }

    public Select havingNot(Condition condition) {
        this.having = condition;
        this.havingConditionType = ConditionType.WHERE_NOT;
        return this;
    }

    public Select orderBy(Column column) {
        return this.orderAscendingBy(column);
    }

    public Select orderAscendingBy(Column column) {
        return this.orderBy(column, OrderDirection.ASC);
    }

    public Select orderDescendingBy(Column column) {
        return this.orderBy(column, OrderDirection.DESC);
    }

    public Select orderBy(Column column, OrderDirection direction) {
        if (this.orderBys == null) {
            this.orderBys = new ArrayList<OrderBy>();
        }
        this.orderBys.add(new OrderBy(column, direction));
        return this;
    }

    public Select limit(long limit, long offset) {
        this.limitation = new Limit(limit, offset);
        return this;
    }

    public Select limit(long limit) {
        return this.limit(limit, 0L);
    }

    @Override
    public String build(Dialect dialect, Indentation indentation) {
        return dialect.build(this, indentation);
    }

    public static void clearSelects(Select select) {
        select.selectables = null;
    }

    public static void clearJoins(Select select) {
        select.joins = null;
    }

    public static void clearWheres(Select select) {
        select.where = null;
    }

    public static void clearGroupBys(Select select) {
        select.groupBys = null;
    }

    public static void clearHavings(Select select) {
        select.having = null;
    }

    public static void clearOrdering(Select select) {
        select.orderBys = null;
    }

    public static void clearLimit(Select select) {
        select.limitation = null;
    }

    public static Select copy(Select select) {
        return new Select(select);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<Selectable> getSelectables() {
        return this.selectables;
    }

    public Queryable getFrom() {
        return this.from;
    }

    public List<Joinable> getJoins() {
        return this.joins;
    }

    public Condition getWhere() {
        return this.where;
    }

    public ConditionType getWhereConditionType() {
        return this.whereConditionType;
    }

    public List<Groupable> getGroupBys() {
        return this.groupBys;
    }

    public Condition getHaving() {
        return this.having;
    }

    public ConditionType getHavingConditionType() {
        return this.havingConditionType;
    }

    public List<OrderBy> getOrderBys() {
        return this.orderBys;
    }

    public Limit getLimitation() {
        return this.limitation;
    }

    public String toString() {
        return "Select(distinct=" + this.isDistinct() + ", selectables=" + this.getSelectables() + ", from=" + this.getFrom() + ", joins=" + this.getJoins() + ", where=" + this.getWhere() + ", whereConditionType=" + this.getWhereConditionType() + ", groupBys=" + this.getGroupBys() + ", having=" + this.getHaving() + ", havingConditionType=" + this.getHavingConditionType() + ", orderBys=" + this.getOrderBys() + ", limitation=" + this.getLimitation() + ")";
    }
}

