/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.queries;

import de.jaggl.sqlbuilder.core.columns.Column;
import de.jaggl.sqlbuilder.core.columns.datetime.DateColumn;
import de.jaggl.sqlbuilder.core.columns.datetime.DateTimeColumn;
import de.jaggl.sqlbuilder.core.columns.number.NumberColumn;
import de.jaggl.sqlbuilder.core.columns.string.StringColumn;
import de.jaggl.sqlbuilder.core.dialect.Dialect;
import de.jaggl.sqlbuilder.core.domain.Placeholder;
import de.jaggl.sqlbuilder.core.domain.PlainValuable;
import de.jaggl.sqlbuilder.core.domain.Valuable;
import de.jaggl.sqlbuilder.core.domain.ValuableColumn;
import de.jaggl.sqlbuilder.core.domain.ValuableFunction;
import de.jaggl.sqlbuilder.core.functions.Function;
import de.jaggl.sqlbuilder.core.queries.UpdatebleQuery;
import de.jaggl.sqlbuilder.core.queryexecutor.QueryExecutor;
import de.jaggl.sqlbuilder.core.schema.Table;
import de.jaggl.sqlbuilder.core.utils.Indentation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class Insert
implements UpdatebleQuery {
    private Table table;
    private Map<Column, Valuable> values = new LinkedHashMap<Column, Valuable>();

    Insert(Insert insert) {
        this.table = insert.table;
        this.values = new LinkedHashMap<Column, Valuable>(insert.values);
    }

    public Insert into(Table insertTable) {
        this.table = insertTable;
        return this;
    }

    public Insert set(StringColumn<?> column, CharSequence value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Insert set(NumberColumn<?, ?> column, Number value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Insert set(NumberColumn<?, ?> column, long value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Insert set(NumberColumn<?, ?> column, double value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Insert set(Column column, Placeholder placeholder) {
        return this.addValue(column, placeholder);
    }

    public Insert set(Column column, Function function) {
        return this.addValue(column, new ValuableFunction(function));
    }

    public Insert set(Column column, Column otherColumn) {
        return this.addValue(column, new ValuableColumn(otherColumn));
    }

    public Insert set(DateColumn column, LocalDate value) {
        return this.addValue(column, new PlainValuable(value));
    }

    public Insert set(DateTimeColumn column, LocalDateTime value) {
        return this.addValue(column, new PlainValuable(value));
    }

    private Insert addValue(Column column, Valuable value) {
        this.values.put(column, value);
        return this;
    }

    @Override
    public String build(Dialect dialect, Indentation indentation) {
        return dialect.build(this, indentation);
    }

    public static Insert copy(Insert insert) {
        return new Insert(insert);
    }

    public long executeAndReturnKey(QueryExecutor queryExecutor) {
        return queryExecutor.executeAndReturnKey(this);
    }

    Insert() {
    }

    public Table getTable() {
        return this.table;
    }

    public Map<Column, Valuable> getValues() {
        return this.values;
    }

    public String toString() {
        return "Insert(table=" + this.getTable() + ", values=" + this.getValues() + ")";
    }
}

