/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.queries;

import de.jaggl.sqlbuilder.core.conditions.CombinedCondition;
import de.jaggl.sqlbuilder.core.conditions.Condition;
import de.jaggl.sqlbuilder.core.dialect.Dialect;
import de.jaggl.sqlbuilder.core.domain.ConditionType;
import de.jaggl.sqlbuilder.core.domain.Limit;
import de.jaggl.sqlbuilder.core.queries.UpdatebleQuery;
import de.jaggl.sqlbuilder.core.schema.Table;
import de.jaggl.sqlbuilder.core.utils.Indentation;

public class Delete
implements UpdatebleQuery {
    private Table table;
    private Condition where;
    private ConditionType whereConditionType;
    private Limit limitation;

    Delete(Delete delete) {
        this.table = delete.table;
        this.where = CombinedCondition.getCopy(delete.where);
        this.whereConditionType = delete.whereConditionType;
        this.limitation = delete.limitation;
    }

    public Delete from(Table deleteTable) {
        this.table = deleteTable;
        return this;
    }

    public Delete where(Condition condition) {
        this.where = condition;
        this.whereConditionType = ConditionType.WHERE;
        return this;
    }

    public Delete whereNot(Condition condition) {
        this.where = condition;
        this.whereConditionType = ConditionType.WHERE_NOT;
        return this;
    }

    public Delete limit(long limit, long offset) {
        this.limitation = new Limit(limit, offset);
        return this;
    }

    public Delete limit(long limit) {
        return this.limit(limit, 0L);
    }

    @Override
    public String build(Dialect dialect, Indentation indentation) {
        return dialect.build(this, indentation);
    }

    public static void clearWheres(Delete delete) {
        delete.where = null;
    }

    public static void clearLimit(Delete delete) {
        delete.limitation = null;
    }

    public static Delete copy(Delete delete) {
        return new Delete(delete);
    }

    Delete() {
    }

    public Table getTable() {
        return this.table;
    }

    public Condition getWhere() {
        return this.where;
    }

    public ConditionType getWhereConditionType() {
        return this.whereConditionType;
    }

    public Limit getLimitation() {
        return this.limitation;
    }

    public String toString() {
        return "Delete(table=" + this.getTable() + ", where=" + this.getWhere() + ", whereConditionType=" + this.getWhereConditionType() + ", limitation=" + this.getLimitation() + ")";
    }
}

