/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.functions;

import de.jaggl.sqlbuilder.core.columns.Column;
import de.jaggl.sqlbuilder.core.conditions.EqualityConditions;
import de.jaggl.sqlbuilder.core.domain.BuildingContext;
import de.jaggl.sqlbuilder.core.functions.Function;
import de.jaggl.sqlbuilder.core.utils.Indentation;

public abstract class ColumnFunction
implements Function,
EqualityConditions {
    protected final Column column;
    protected final String definition;
    private String alias;

    @Override
    public String getValue(BuildingContext context, Indentation indentation) {
        return this.definition + "(" + this.column.getFullNameOrAlias(context) + ")";
    }

    public ColumnFunction(Column column, String definition, String alias) {
        this.column = column;
        this.definition = definition;
        this.alias = alias;
    }

    public ColumnFunction(Column column, String definition) {
        this.column = column;
        this.definition = definition;
    }

    public String toString() {
        return "ColumnFunction(column=" + this.column + ", definition=" + this.definition + ", alias=" + this.getAlias() + ")";
    }

    @Override
    public String getAlias() {
        return this.alias;
    }
}

