/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.domain;

import de.jaggl.sqlbuilder.core.conditions.CombinedCondition;
import de.jaggl.sqlbuilder.core.conditions.Condition;
import de.jaggl.sqlbuilder.core.domain.BuildingContext;
import de.jaggl.sqlbuilder.core.domain.JoinType;
import de.jaggl.sqlbuilder.core.domain.Joinable;
import de.jaggl.sqlbuilder.core.schema.Table;
import de.jaggl.sqlbuilder.core.utils.BuilderUtils;
import de.jaggl.sqlbuilder.core.utils.Indentation;

public class JoinableTable
implements Joinable {
    private JoinType joinType;
    private Table table;
    private Condition condition;

    @Override
    public String getValue(BuildingContext context, Indentation indentation) {
        return JoinableTable.buildJoin(this.joinType, this.table.getFullName(context), this.table.getAlias(), this.condition, context, indentation);
    }

    private static String buildJoin(JoinType joinType, String plainJoinable, String alias, Condition condition, BuildingContext context, Indentation indentation) {
        StringBuilder builder = new StringBuilder();
        if (joinType != null) {
            builder.append(joinType.getValue()).append(" ");
        }
        builder.append("JOIN ").append(plainJoinable);
        if (alias != null) {
            builder.append(" AS ").append(BuilderUtils.columnApostrophe(alias, context));
        }
        builder.append(" ON").append(CombinedCondition.class.isAssignableFrom(condition.getClass()) ? context.getDelimiter() : " ").append(condition.build(context, false, indentation));
        return builder.toString();
    }

    public JoinableTable(JoinType joinType, Table table, Condition condition) {
        this.joinType = joinType;
        this.table = table;
        this.condition = condition;
    }

    public String toString() {
        return "JoinableTable(joinType=" + this.joinType + ", table=" + this.getTable() + ", condition=" + this.getCondition() + ")";
    }

    public Table getTable() {
        return this.table;
    }

    public Condition getCondition() {
        return this.condition;
    }
}

