/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.dialect;

import de.jaggl.sqlbuilder.core.columns.Column;
import de.jaggl.sqlbuilder.core.dialect.DefaultDialect;
import de.jaggl.sqlbuilder.core.dialect.Dialect;
import de.jaggl.sqlbuilder.core.domain.BuildingContext;
import de.jaggl.sqlbuilder.core.domain.Limit;
import de.jaggl.sqlbuilder.core.domain.Valuable;
import de.jaggl.sqlbuilder.core.domain.ValuableColumn;
import de.jaggl.sqlbuilder.core.queries.Delete;
import de.jaggl.sqlbuilder.core.queries.Insert;
import de.jaggl.sqlbuilder.core.queries.Select;
import de.jaggl.sqlbuilder.core.utils.BuilderUtils;
import de.jaggl.sqlbuilder.core.utils.Indentation;
import java.util.Map;

public class SybaseDialect
extends DefaultDialect {
    private static final SybaseDialect instance = new SybaseDialect();

    private SybaseDialect() {
    }

    @Override
    public String getName() {
        return "Sybase";
    }

    @Override
    protected void appendInsertStatement(StringBuilder builder, Insert insert, BuildingContext context, Indentation indentation) {
        builder.append(context.getDialect().getLabels().getInsertInto()).append(" ").append(insert.getTable().getFullName(context));
        builder.append(indentation.getDelimiter());
        this.appendInsertColumns(builder, insert.getValues(), context, indentation.indent());
        this.appendInsertValues(builder, insert.getValues(), context, indentation.indent());
    }

    protected void appendInsertColumns(StringBuilder builder, Map<Column, Valuable> values, BuildingContext context, Indentation indentation) {
        int counter = 0;
        builder.append(indentation.getIndent()).append("(");
        for (Map.Entry<Column, Valuable> entry : values.entrySet()) {
            Column column = entry.getKey();
            builder.append(BuilderUtils.columnApostrophe(column.getName(), context));
            if (++counter >= values.size()) continue;
            builder.append(", ");
        }
        builder.append(")").append(indentation.getDelimiter());
    }

    protected void appendInsertValues(StringBuilder builder, Map<Column, Valuable> values, BuildingContext context, Indentation indentation) {
        int counter = 0;
        builder.append("VALUES").append(indentation.getDelimiter());
        builder.append(indentation.getIndent()).append("(");
        for (Map.Entry<Column, Valuable> entry : values.entrySet()) {
            Valuable value = entry.getValue();
            if (ValuableColumn.class.isAssignableFrom(value.getClass())) {
                builder.append(BuilderUtils.columnApostrophe(((ValuableColumn)value).getName(), context));
            } else {
                builder.append(value.getValue(context, indentation));
            }
            if (++counter >= values.size()) continue;
            builder.append(", ");
        }
        builder.append(")");
    }

    @Override
    protected void appendSelectStatement(StringBuilder builder, Select select, BuildingContext context, Indentation indentation) {
        builder.append(context.getDialect().getLabels().getSelect());
        this.appendLimit(builder, select.getLimitation(), context, indentation);
        this.appendDistinct(builder, select.isDistinct(), context, indentation);
        this.appendSelectables(builder, select.getSelectables(), context, indentation);
        this.appendQueryables(builder, select.getFrom(), context, indentation);
        this.appendJoins(builder, select.getJoins(), context, indentation);
        this.appendConditions(context.getDialect().getLabels().getWhere(), builder, select.getWhere(), select.getWhereConditionType(), context, indentation);
        this.appendGrouping(builder, select.getGroupBys(), context, indentation);
        this.appendConditions(context.getDialect().getLabels().getHaving(), builder, select.getHaving(), select.getHavingConditionType(), context, indentation);
        this.appendOrdering(builder, select.getOrderBys(), context, indentation);
    }

    @Override
    protected void appendDeleteStatement(StringBuilder builder, Delete delete, BuildingContext context, Indentation indentation) {
        builder.append(context.getDialect().getLabels().getDelete());
        this.appendLimit(builder, delete.getLimitation(), context, indentation);
        if (delete.getLimitation() != null) {
            builder.append(" ");
        }
        builder.append(context.getDialect().getLabels().getFrom()).append(indentation.getDelimiter());
        builder.append(indentation.indent().getIndent()).append(delete.getTable().getFullName(context));
        this.appendConditions(context.getDialect().getLabels().getWhere(), builder, delete.getWhere(), delete.getWhereConditionType(), context, indentation);
    }

    @Override
    protected void appendLimit(StringBuilder builder, Limit limit, BuildingContext context, Indentation indentation) {
        if (limit != null) {
            builder.append(" TOP ").append(limit.getLimit());
            if (limit.getOffset() > 0L) {
                builder.append(" START AT ").append(limit.getOffset() + 1L);
            }
        }
    }

    public static SybaseDialect getInstance() {
        return instance;
    }

    static {
        Dialect.register(instance);
    }
}

