/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.dialect;

import de.jaggl.sqlbuilder.core.dialect.Dialects;
import de.jaggl.sqlbuilder.core.dialect.Labels;
import de.jaggl.sqlbuilder.core.queries.CreateTable;
import de.jaggl.sqlbuilder.core.queries.Delete;
import de.jaggl.sqlbuilder.core.queries.Insert;
import de.jaggl.sqlbuilder.core.queries.Select;
import de.jaggl.sqlbuilder.core.queries.Update;
import de.jaggl.sqlbuilder.core.utils.Indentation;
import java.time.format.DateTimeFormatter;

public interface Dialect {
    public String getName();

    public String build(Insert var1, Indentation var2);

    public String build(Update var1, Indentation var2);

    public String build(Delete var1, Indentation var2);

    public String build(Select var1, Indentation var2);

    public String build(CreateTable var1, Indentation var2);

    public DateTimeFormatter getDateFormatter();

    public DateTimeFormatter getDateTimeFormatter();

    public Labels getLabels();

    public static void register(Dialect dialect) {
        Dialects.register(dialect);
    }

    public static void unregister(String name) {
        Dialects.unregister(name);
    }

    public static Dialect forName(String name) {
        return Dialects.forName(name);
    }

    public static Dialect getDefault() {
        return Dialect.forName(System.getProperty("sqlbuilder.defaultDialect", "MYSQL"));
    }
}

