/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.conditions;

import de.jaggl.sqlbuilder.core.columns.Column;
import de.jaggl.sqlbuilder.core.conditions.Condition;
import de.jaggl.sqlbuilder.core.conditions.GenericCondition;
import de.jaggl.sqlbuilder.core.conditions.LikeConditions;
import de.jaggl.sqlbuilder.core.domain.Placeholder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.function.Function;

public interface DateTimeConditions
extends LikeConditions {
    public Function<ZonedDateTime, Temporal> getDateConversion();

    default public Condition isEqualTo(LocalDate value) {
        return value == null ? new GenericCondition(GenericCondition.GenericConditionType.IS_NULL, this) : new GenericCondition(GenericCondition.GenericConditionType.IS_EQUAL_TO, this, value);
    }

    default public Condition eq(LocalDate value) {
        return this.isEqualTo(value);
    }

    default public Condition isEqualTo(LocalDateTime value) {
        return value == null ? new GenericCondition(GenericCondition.GenericConditionType.IS_NULL, this) : new GenericCondition(GenericCondition.GenericConditionType.IS_EQUAL_TO, this, value);
    }

    default public Condition eq(LocalDateTime value) {
        return this.isEqualTo(value);
    }

    default public Condition isEqualTo(Date value) {
        return value == null ? new GenericCondition(GenericCondition.GenericConditionType.IS_NULL, this) : new GenericCondition(GenericCondition.GenericConditionType.IS_EQUAL_TO, this, DateTimeConditions.convert(value, this.getDateConversion()));
    }

    default public Condition eq(Date value) {
        return this.isEqualTo(value);
    }

    default public Condition isNotEqualTo(LocalDate value) {
        return value == null ? new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_NULL, this) : new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_EQUAL_TO, this, value);
    }

    default public Condition nEq(LocalDate value) {
        return this.isNotEqualTo(value);
    }

    default public Condition isNotEqualTo(LocalDateTime value) {
        return value == null ? new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_NULL, this) : new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_EQUAL_TO, this, value);
    }

    default public Condition nEq(LocalDateTime value) {
        return this.isNotEqualTo(value);
    }

    default public Condition isNotEqualTo(Date value) {
        return value == null ? new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_NULL, this) : new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_EQUAL_TO, this, DateTimeConditions.convert(value, this.getDateConversion()));
    }

    default public Condition nEq(Date value) {
        return this.isNotEqualTo(value);
    }

    default public Condition isAfter(LocalDate value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN, this, value);
    }

    default public Condition isAfter(LocalDateTime value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN, this, value);
    }

    default public Condition isAfter(Date value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN, this, DateTimeConditions.convert(value, this.getDateConversion()));
    }

    default public Condition isAfter(Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN, this, otherColumn);
    }

    default public Condition isAfter(Placeholder placeholder) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN, this, placeholder);
    }

    default public Condition isAfterOrEqualTo(LocalDate value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN_OR_EQUAL_TO, this, value);
    }

    default public Condition isAfterOrEqualTo(LocalDateTime value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN_OR_EQUAL_TO, this, value);
    }

    default public Condition isAfterOrEqualTo(Date value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN_OR_EQUAL_TO, this, DateTimeConditions.convert(value, this.getDateConversion()));
    }

    default public Condition isAfterOrEqualTo(Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN_OR_EQUAL_TO, this, otherColumn);
    }

    default public Condition isAfterOrEqualTo(Placeholder placeholder) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_GREATER_THAN_OR_EQUAL_TO, this, placeholder);
    }

    default public Condition isBefore(LocalDate value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN, this, value);
    }

    default public Condition isBefore(LocalDateTime value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN, this, value);
    }

    default public Condition isBefore(Date value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN, this, DateTimeConditions.convert(value, this.getDateConversion()));
    }

    default public Condition isBefore(Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN, this, otherColumn);
    }

    default public Condition isBefore(Placeholder placeholder) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN, this, placeholder);
    }

    default public Condition isBeforeOrEqualTo(LocalDate value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN_OR_EQUAL_TO, this, value);
    }

    default public Condition isBeforeOrEqualTo(LocalDateTime value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN_OR_EQUAL_TO, this, value);
    }

    default public Condition isBeforeOrEqualTo(Date value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN_OR_EQUAL_TO, this, DateTimeConditions.convert(value, this.getDateConversion()));
    }

    default public Condition isBeforeOrEqualTo(Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN_OR_EQUAL_TO, this, otherColumn);
    }

    default public Condition isBeforeOrEqualTo(Placeholder placeholder) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_LESS_THAN_OR_EQUAL_TO, this, placeholder);
    }

    default public Condition isBetween(LocalDate value1, LocalDate value2) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, value1, value2);
    }

    default public Condition isBetween(Date value1, Date value2) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, DateTimeConditions.convert(value1, this.getDateConversion()), DateTimeConditions.convert(value2, this.getDateConversion()));
    }

    default public Condition isBetween(LocalDate value1, Date value2) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, value1, DateTimeConditions.convert(value2, this.getDateConversion()));
    }

    default public Condition isBetween(Date value1, LocalDate value2) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, DateTimeConditions.convert(value1, this.getDateConversion()), value2);
    }

    default public Condition isBetween(Column otherColumn1, Column otherColumn2) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, otherColumn1, otherColumn2);
    }

    default public Condition isBetween(LocalDate value, Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, value, otherColumn);
    }

    default public Condition isBetween(Date value, Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, DateTimeConditions.convert(value, this.getDateConversion()), otherColumn);
    }

    default public Condition isBetween(Column otherColumn, LocalDate value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, otherColumn, value);
    }

    default public Condition isBetween(Column otherColumn, Date value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, otherColumn, DateTimeConditions.convert(value, this.getDateConversion()));
    }

    default public Condition isBetween(LocalDateTime value1, LocalDateTime value2) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, value1, value2);
    }

    default public Condition isBetween(LocalDateTime value1, Date value2) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, value1, value2.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    default public Condition isBetween(Date value1, LocalDateTime value2) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, value1.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime(), value2);
    }

    default public Condition isBetween(LocalDateTime value, Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, value, otherColumn);
    }

    default public Condition isBetween(Column otherColumn, LocalDateTime value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, otherColumn, value);
    }

    default public Condition isBetween(Column otherColumn, Placeholder placeholder) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, otherColumn, placeholder);
    }

    default public Condition isBetween(LocalDate value, Placeholder placeholder) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, value, placeholder);
    }

    default public Condition isBetween(Date value, Placeholder placeholder) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, DateTimeConditions.convert(value, this.getDateConversion()), placeholder);
    }

    default public Condition isBetween(Placeholder placeholder, Date value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, placeholder, DateTimeConditions.convert(value, this.getDateConversion()));
    }

    default public Condition isBetween(Placeholder placeholder, LocalDate value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, placeholder, value);
    }

    default public Condition isBetween(Placeholder placeholder, Column otherColumn) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, placeholder, otherColumn);
    }

    default public Condition isBetween(LocalDateTime value, Placeholder placeholder) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, value, placeholder);
    }

    default public Condition isBetween(Placeholder placeholder, LocalDateTime value) {
        return new GenericCondition(GenericCondition.GenericConditionType.IS_BETWEEN, this, placeholder, value);
    }

    private static Temporal convert(Date date, Function<ZonedDateTime, Temporal> convertFunction) {
        return convertFunction.apply(date.toInstant().atZone(ZoneId.systemDefault()));
    }
}

