/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.conditions;

import de.jaggl.sqlbuilder.core.conditions.CombinedCondition;
import de.jaggl.sqlbuilder.core.conditions.EmptyCondition;
import de.jaggl.sqlbuilder.core.conditions.PlainCondition;
import de.jaggl.sqlbuilder.core.domain.BuildingContext;
import de.jaggl.sqlbuilder.core.domain.ConcatenationType;
import de.jaggl.sqlbuilder.core.domain.ConditionType;
import de.jaggl.sqlbuilder.core.domain.Placeholder;
import de.jaggl.sqlbuilder.core.domain.SqlTypeSupplier;
import de.jaggl.sqlbuilder.core.utils.Indentation;
import java.util.ArrayList;
import java.util.List;

public abstract class Condition {
    private ConditionType type;
    private ConcatenationType concatenation;
    private List<Integer> placeholderSqlTypes;

    protected abstract String doBuild(BuildingContext var1, Indentation var2);

    public String build(BuildingContext context, boolean concatenate, Indentation indentation) {
        StringBuilder builder = new StringBuilder();
        if (concatenate) {
            builder.append(this.concatenation == ConcatenationType.AND ? context.getDialect().getLabels().getAnd() : context.getDialect().getLabels().getOr());
        }
        if (this.type == ConditionType.WHERE_NOT) {
            builder.append(" ").append(context.getDialect().getLabels().getNot());
        }
        if (concatenate) {
            if (indentation.isEnabled() && CombinedCondition.class.isAssignableFrom(this.getClass())) {
                builder.append(context.getDelimiter());
            } else {
                builder.append(" ");
            }
        }
        builder.append(this.doBuild(context, indentation));
        return builder.toString();
    }

    public Condition and(Condition other) {
        return this.append(other, ConcatenationType.AND, ConditionType.WHERE);
    }

    public Condition or(Condition other) {
        return this.append(other, ConcatenationType.OR, ConditionType.WHERE);
    }

    public Condition andNot(Condition other) {
        return this.append(other, ConcatenationType.AND, ConditionType.WHERE_NOT);
    }

    public Condition orNot(Condition other) {
        return this.append(other, ConcatenationType.OR, ConditionType.WHERE_NOT);
    }

    public Condition append(Condition other, ConcatenationType concatenationType, ConditionType conditionType) {
        other.setConcatenation(concatenationType);
        other.setType(conditionType);
        if (EmptyCondition.class.isAssignableFrom(this.getClass())) {
            return other;
        }
        CombinedCondition combined = !CombinedCondition.class.isAssignableFrom(this.getClass()) ? new CombinedCondition(this) : (CombinedCondition)this;
        combined.append(other);
        return combined;
    }

    public static Condition plain(String plainCondition) {
        return new PlainCondition(plainCondition);
    }

    public static Condition emptyCondition() {
        return new EmptyCondition();
    }

    public static Condition nested(Condition condition) {
        return new CombinedCondition(condition);
    }

    protected void addPlaceholderSqlTypes(List<Integer> sqlTypes) {
        if (sqlTypes != null) {
            if (this.placeholderSqlTypes == null) {
                this.placeholderSqlTypes = new ArrayList<Integer>();
            }
            this.placeholderSqlTypes.addAll(sqlTypes);
        }
    }

    protected static List<Integer> resolvePlaceholderSqlTypes(Object ... values) {
        ArrayList<Integer> placeholderSqlTypes = new ArrayList<Integer>();
        if (values.length > 1 && SqlTypeSupplier.class.isAssignableFrom(values[0].getClass())) {
            for (int i = 1; i < values.length; ++i) {
                if (values[i] == null || !Placeholder.class.isAssignableFrom(values[i].getClass())) continue;
                placeholderSqlTypes.add(((SqlTypeSupplier)values[0]).getSqlType());
            }
        }
        return placeholderSqlTypes;
    }

    public List<Integer> getPlaceholderSqlTypes() {
        return this.placeholderSqlTypes;
    }

    public ConditionType getType() {
        return this.type;
    }

    public ConcatenationType getConcatenation() {
        return this.concatenation;
    }

    public String toString() {
        return "Condition(type=" + this.getType() + ", concatenation=" + this.getConcatenation() + ", placeholderSqlTypes=" + this.getPlaceholderSqlTypes() + ")";
    }

    public void setType(ConditionType type) {
        this.type = type;
    }

    public void setConcatenation(ConcatenationType concatenation) {
        this.concatenation = concatenation;
    }
}

