/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.columns;

import de.jaggl.sqlbuilder.core.columns.Column;
import de.jaggl.sqlbuilder.core.schema.Table;
import de.jaggl.sqlbuilder.core.schema.TableBuilderUtil;

public abstract class ColumnBuilder<C extends Column, B extends ColumnBuilder<C, B, V>, V> {
    protected final Table table;
    protected final String name;
    protected boolean isNullable = true;
    protected boolean isDefaultNull = true;
    protected V defaultValue;

    protected abstract C getColumnInstance();

    public C build() {
        C columnInstance = this.getColumnInstance();
        TableBuilderUtil.addColumnToTable(columnInstance, this.table);
        return columnInstance;
    }

    public B nullable(boolean nullable) {
        this.isNullable = nullable;
        return (B)this;
    }

    public B defaultValue(V value) {
        this.isDefaultNull = false;
        this.defaultValue = value;
        return (B)this;
    }

    public B defaultNull() {
        this.isNullable = true;
        this.defaultValue = null;
        this.isDefaultNull = true;
        return (B)this;
    }

    public B noDefault() {
        this.defaultValue = null;
        this.isDefaultNull = false;
        return (B)this;
    }

    public B nullable() {
        return this.nullable(true);
    }

    public B notNull() {
        return this.nullable(false);
    }

    public ColumnBuilder(Table table, String name) {
        this.table = table;
        this.name = name;
    }
}

