/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.core.columns;

import de.jaggl.sqlbuilder.core.columns.ColumnDefinition;
import de.jaggl.sqlbuilder.core.conditions.EqualityConditions;
import de.jaggl.sqlbuilder.core.conditions.NullableConditions;
import de.jaggl.sqlbuilder.core.domain.BuildingContext;
import de.jaggl.sqlbuilder.core.domain.Definable;
import de.jaggl.sqlbuilder.core.domain.Groupable;
import de.jaggl.sqlbuilder.core.domain.Selectable;
import de.jaggl.sqlbuilder.core.domain.SqlTypeSupplier;
import de.jaggl.sqlbuilder.core.schema.Table;
import de.jaggl.sqlbuilder.core.utils.BuilderUtils;
import de.jaggl.sqlbuilder.core.utils.Indentation;

public abstract class Column
implements Groupable,
Selectable,
Definable,
NullableConditions,
EqualityConditions,
SqlTypeSupplier {
    protected Table table;
    protected String name;
    private String alias;
    protected ColumnDefinition columnDefinition;
    private int sqlType;

    @Override
    public String getValue(BuildingContext context, Indentation indentation) {
        return this.getFullNameOrAlias(context);
    }

    public String getFullName(BuildingContext context) {
        return this.table.getFullName(context) + "." + BuilderUtils.columnApostrophe(this.name, context);
    }

    public String getFullNameOrAlias(BuildingContext context) {
        return this.table.getFullNameOrAlias(context) + "." + BuilderUtils.columnApostrophe(this.name, context);
    }

    public Column(Table table, String name, String alias, ColumnDefinition columnDefinition, int sqlType) {
        this.table = table;
        this.name = name;
        this.alias = alias;
        this.columnDefinition = columnDefinition;
        this.sqlType = sqlType;
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public ColumnDefinition getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", alias=" + this.getAlias() + ", columnDefinition=" + this.getColumnDefinition() + ", sqlType=" + this.getSqlType() + ")";
    }
}

