/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.queries;

import de.jaggl.sqlbuilder.dialect.Dialect;
import de.jaggl.sqlbuilder.utils.Indentation;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public interface Query {
    public String build(Dialect var1, Indentation var2);

    default public String build() {
        return this.build(Dialect.getDefault());
    }

    default public String build(Indentation indentation) {
        return this.build(Dialect.getDefault(), indentation);
    }

    default public String build(Dialect dialect) {
        return this.build(dialect, Indentation.disabled());
    }

    default public String build(String dialectName) {
        return this.build(Dialect.forName(dialectName));
    }

    default public String build(String dialectName, Indentation indentation) {
        return this.build(Dialect.forName(dialectName), indentation);
    }

    default public void print() {
        this.print(System.out);
    }

    default public void print(Indentation indentation) {
        this.print(System.out, indentation);
    }

    default public void print(Dialect dialect) {
        this.print(System.out, dialect);
    }

    default public void print(String dialectName) {
        this.print(Dialect.forName(dialectName));
    }

    default public void print(Dialect dialect, Indentation indentation) {
        this.print(System.out, dialect, indentation);
    }

    default public void print(String dialectName, Indentation indentation) {
        this.print(Dialect.forName(dialectName), indentation);
    }

    default public void print(PrintStream printStream) {
        printStream.print(this.build());
    }

    default public void print(PrintStream printStream, Indentation indentation) {
        printStream.print(this.build(indentation));
    }

    default public void print(PrintStream printStream, Dialect dialect) {
        printStream.print(this.build(dialect));
    }

    default public void print(PrintStream printStream, String dialectName) {
        this.print(printStream, Dialect.forName(dialectName));
    }

    default public void print(PrintStream printStream, Dialect dialect, Indentation indentation) {
        printStream.print(this.build(dialect, indentation));
    }

    default public void print(PrintStream printStream, String dialectName, Indentation indentation) {
        this.print(printStream, Dialect.forName(dialectName), indentation);
    }

    default public void println() {
        this.println(System.out);
    }

    default public void println(Indentation indentation) {
        this.println(System.out, indentation);
    }

    default public void println(Dialect dialect) {
        this.println(System.out, dialect);
    }

    default public void println(String dialectName) {
        this.println(Dialect.forName(dialectName));
    }

    default public void println(Dialect dialect, Indentation indentation) {
        this.println(System.out, dialect, indentation);
    }

    default public void println(String dialectName, Indentation indentation) {
        this.println(Dialect.forName(dialectName), indentation);
    }

    default public void println(PrintStream printStream) {
        printStream.println(this.build());
    }

    default public void println(PrintStream printStream, Indentation indentation) {
        printStream.println(this.build(indentation));
    }

    default public void println(PrintStream printStream, Dialect dialect) {
        printStream.println(this.build(dialect));
    }

    default public void println(PrintStream printStream, String dialectName) {
        this.println(printStream, Dialect.forName(dialectName));
    }

    default public void println(PrintStream printStream, Dialect dialect, Indentation indentation) {
        printStream.println(this.build(dialect, indentation));
    }

    default public void println(PrintStream printStream, String dialectName, Indentation indentation) {
        this.println(printStream, Dialect.forName(dialectName), indentation);
    }

    default public PreparedStatement prepare(Connection connection) throws SQLException {
        return connection.prepareStatement(this.build());
    }

    default public PreparedStatement prepare(Connection connection, Dialect dialect) throws SQLException {
        return connection.prepareStatement(this.build(dialect));
    }

    default public PreparedStatement prepare(Connection connection, String dialectName) throws SQLException {
        return connection.prepareStatement(this.build(dialectName));
    }
}

