/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.domain;

import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.domain.Queryable;
import de.jaggl.sqlbuilder.queries.Select;
import de.jaggl.sqlbuilder.utils.Indentation;

public class QueryableSelect
implements Queryable {
    private Select select;
    private String alias;

    @Override
    public String getValue(BuildingContext context, Indentation indentation) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (indentation.isEnabled()) {
            builder.append(context.getDelimiter());
        }
        builder.append(this.select.build(context.getDialect(), indentation.indent()));
        if (indentation.isEnabled()) {
            builder.append(context.getDelimiter()).append(indentation.deIndent().getIndent());
        }
        builder.append(")");
        return builder.toString();
    }

    public QueryableSelect(Select select, String alias) {
        this.select = select;
        this.alias = alias;
    }

    public String toString() {
        return "QueryableSelect(select=" + this.select + ", alias=" + this.getAlias() + ")";
    }

    @Override
    public String getAlias() {
        return this.alias;
    }
}

