/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.dialect;

import de.jaggl.sqlbuilder.dialect.Dialect;
import de.jaggl.sqlbuilder.dialect.MySqlDialect;
import de.jaggl.sqlbuilder.dialect.SybaseDialect;
import de.jaggl.sqlbuilder.domain.exceptions.UnknownDialectException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public final class Dialects {
    private static final Map<String, Dialect> REGISTERED_DIALECTS = new HashMap<String, Dialect>();
    public static final Dialect MYSQL = MySqlDialect.getInstance();
    public static final Dialect SYBASE = SybaseDialect.getInstance();

    private Dialects() {
    }

    static void register(Dialect dialect) {
        REGISTERED_DIALECTS.put(dialect.getName().toLowerCase(), dialect);
    }

    static void unregister(String name) {
        REGISTERED_DIALECTS.remove(name.toLowerCase());
    }

    static Dialect forName(String name) {
        Dialect dialect = REGISTERED_DIALECTS.get(name.toLowerCase());
        if (dialect == null) {
            throw new UnknownDialectException(MessageFormat.format("no dialect registered for name ''{0}''", name));
        }
        return dialect;
    }
}

