/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.functions;

import de.jaggl.sqlbuilder.columns.Column;
import de.jaggl.sqlbuilder.conditions.EqualityConditions;
import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.functions.Function;
import de.jaggl.sqlbuilder.utils.Indentation;

public abstract class ColumnFunction
implements Function,
EqualityConditions {
    protected final Column column;
    protected final String definition;
    private String alias;

    @Override
    public String getValue(BuildingContext context, Indentation indentation) {
        return this.definition + "(" + this.column.getFullNameOrAlias(context) + ")";
    }

    public ColumnFunction(Column column, String definition, String alias) {
        this.column = column;
        this.definition = definition;
        this.alias = alias;
    }

    public ColumnFunction(Column column, String definition) {
        this.column = column;
        this.definition = definition;
    }

    public String toString() {
        return "ColumnFunction(column=" + this.column + ", definition=" + this.definition + ", alias=" + this.getAlias() + ")";
    }

    @Override
    public String getAlias() {
        return this.alias;
    }
}

