/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.conditions;

import de.jaggl.sqlbuilder.conditions.Condition;
import de.jaggl.sqlbuilder.conditions.GenericCondition;
import de.jaggl.sqlbuilder.conditions.IsIn;
import de.jaggl.sqlbuilder.conditions.IsNotIn;
import de.jaggl.sqlbuilder.conditions.LikeConditions;
import de.jaggl.sqlbuilder.domain.Placeholder;
import de.jaggl.sqlbuilder.utils.ArrayUtils;
import java.util.Collection;
import java.util.stream.Collectors;

public interface StringConditions
extends LikeConditions {
    default public Condition isEqualTo(String value) {
        return value == null ? new GenericCondition(GenericCondition.GenericConditionType.IS_NULL, this) : new GenericCondition(GenericCondition.GenericConditionType.IS_EQUAL_TO, this, value);
    }

    default public Condition eq(String value) {
        return this.isEqualTo(value);
    }

    default public Condition isNotEqualTo(String value) {
        return value == null ? new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_NULL, this) : new GenericCondition(GenericCondition.GenericConditionType.IS_NOT_EQUAL_TO, this, value);
    }

    default public Condition nEq(String value) {
        return this.isNotEqualTo(value);
    }

    default public Condition isIn(Collection<CharSequence> values) {
        return new IsIn((Object)this, values.stream().map(value -> value).collect(Collectors.toList()));
    }

    default public Condition isIn(CharSequence value, CharSequence ... furtherValues) {
        return new IsIn((Object)this, ArrayUtils.toList(value, furtherValues));
    }

    default public Condition isIn(Placeholder placeholder) {
        return new IsIn((Object)this, placeholder);
    }

    default public Condition isNotIn(Collection<CharSequence> values) {
        return new IsNotIn((Object)this, values.stream().map(value -> value).collect(Collectors.toList()));
    }

    default public Condition isNotIn(CharSequence value, CharSequence ... furtherValues) {
        return new IsNotIn((Object)this, ArrayUtils.toList(value, furtherValues));
    }

    default public Condition isNotIn(Placeholder placeholder) {
        return new IsNotIn((Object)this, placeholder);
    }
}

