/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.conditions;

import de.jaggl.sqlbuilder.conditions.Condition;
import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.domain.Placeholder;
import de.jaggl.sqlbuilder.utils.BuilderUtils;
import de.jaggl.sqlbuilder.utils.Indentation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.stream.Collectors;

public class IsNotIn
extends Condition {
    private final Object value;
    private final Collection<Object> values;
    private Placeholder placeholder;

    public IsNotIn(Object value, Placeholder placeholder) {
        this.value = value;
        this.values = null;
        this.placeholder = placeholder;
        this.addPlaceholderSqlTypes(IsNotIn.resolvePlaceholderSqlTypes(value, placeholder));
    }

    @Override
    protected String doBuild(BuildingContext context, Indentation indentation) {
        if (this.values != null) {
            return MessageFormat.format(context.getDialect().getLabels().getIsNotIn(), BuilderUtils.getValued(this.value, context, indentation), this.values.stream().map(item -> BuilderUtils.getValued(item, context, indentation)).collect(Collectors.joining(", ")));
        }
        return MessageFormat.format(context.getDialect().getLabels().getIsNotIn(), BuilderUtils.getValued(this.value, context, indentation), BuilderUtils.getValued(this.placeholder, context, indentation));
    }

    public IsNotIn(Object value, Collection<Object> values) {
        this.value = value;
        this.values = values;
    }

    @Override
    public String toString() {
        return "IsNotIn(super=" + super.toString() + ", value=" + this.value + ", values=" + this.values + ", placeholder=" + this.placeholder + ")";
    }
}

