/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.conditions;

import de.jaggl.sqlbuilder.conditions.Condition;
import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.domain.Placeholder;
import de.jaggl.sqlbuilder.utils.BuilderUtils;
import de.jaggl.sqlbuilder.utils.Indentation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.stream.Collectors;

public class IsIn
extends Condition {
    private final Object value;
    private final Collection<Object> values;
    private Placeholder placeholder;

    public IsIn(Object value, Placeholder placeholder) {
        this.value = value;
        this.values = null;
        this.placeholder = placeholder;
        this.addPlaceholderSqlTypes(IsIn.resolvePlaceholderSqlTypes(value, placeholder));
    }

    @Override
    protected String doBuild(BuildingContext context, Indentation indentation) {
        if (this.values != null) {
            return MessageFormat.format(context.getDialect().getLabels().getIsIn(), BuilderUtils.getValued(this.value, context, indentation), this.values.stream().map(item -> BuilderUtils.getValued(item, context, indentation)).collect(Collectors.joining(", ")));
        }
        return MessageFormat.format(context.getDialect().getLabels().getIsIn(), BuilderUtils.getValued(this.value, context, indentation), BuilderUtils.getValued(this.placeholder, context, indentation));
    }

    public IsIn(Object value, Collection<Object> values) {
        this.value = value;
        this.values = values;
    }

    @Override
    public String toString() {
        return "IsIn(super=" + super.toString() + ", value=" + this.value + ", values=" + this.values + ", placeholder=" + this.placeholder + ")";
    }
}

