/*
 * Decompiled with CFR 0.152.
 */
package de.jaggl.sqlbuilder.columns;

import de.jaggl.sqlbuilder.columns.ColumnDefinition;
import de.jaggl.sqlbuilder.conditions.EqualityConditions;
import de.jaggl.sqlbuilder.conditions.NullableConditions;
import de.jaggl.sqlbuilder.domain.BuildingContext;
import de.jaggl.sqlbuilder.domain.Definable;
import de.jaggl.sqlbuilder.domain.Groupable;
import de.jaggl.sqlbuilder.domain.Selectable;
import de.jaggl.sqlbuilder.domain.SqlTypeSupplier;
import de.jaggl.sqlbuilder.schema.Table;
import de.jaggl.sqlbuilder.utils.BuilderUtils;
import de.jaggl.sqlbuilder.utils.Indentation;

public abstract class Column
implements Groupable,
Selectable,
Definable,
NullableConditions,
EqualityConditions,
SqlTypeSupplier {
    protected Table table;
    protected String name;
    private String alias;
    protected ColumnDefinition columnDefinition;
    private int sqlType;

    @Override
    public String getValue(BuildingContext context, Indentation indentation) {
        return this.getFullNameOrAlias(context);
    }

    public String getFullName(BuildingContext context) {
        return this.table.getFullName(context) + "." + BuilderUtils.columnApostrophe(this.name, context);
    }

    public String getFullNameOrAlias(BuildingContext context) {
        return this.table.getFullNameOrAlias(context) + "." + BuilderUtils.columnApostrophe(this.name, context);
    }

    public Column(Table table, String name, String alias, ColumnDefinition columnDefinition, int sqlType) {
        this.table = table;
        this.name = name;
        this.alias = alias;
        this.columnDefinition = columnDefinition;
        this.sqlType = sqlType;
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public ColumnDefinition getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", alias=" + this.getAlias() + ", columnDefinition=" + this.getColumnDefinition() + ", sqlType=" + this.getSqlType() + ")";
    }
}

